package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIAjaxRegion;

public class HtmlAjaxRegion extends UIAjaxRegion{

final public static  String COMPONENT_FAMILY = "org.ajax4jsf.AjaxRegion";

final public static  String COMPONENT_TYPE = "org.ajax4jsf.AjaxRegion";

/*
* Excludes all the components from the outside of the region from updating on the page on Renderer Response phase.
			      Default value is "false".
*/
private  boolean _renderRegionOnly = false;

private  boolean _renderRegionOnlySet = false;

/*
* null
*/
private  String _submittedControlId = null;


public HtmlAjaxRegion(){
setRendererType("org.ajax4jsf.components.AjaxRegionRenderer");
}

public boolean isRenderRegionOnly(){
	if (this._renderRegionOnlySet) {
	    return (this._renderRegionOnly);
	}
	ValueExpression ve = getValueExpression("renderRegionOnly");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._renderRegionOnly);
	    }
	    
	    return value;
	} else {
	    return (this._renderRegionOnly);
	}

}

public void setRenderRegionOnly(boolean _renderRegionOnly){
this._renderRegionOnly = _renderRegionOnly;
this._renderRegionOnlySet = true;
}

public String getSubmittedControlId(){
	if (this._submittedControlId != null) {
		return this._submittedControlId;
	}
	ValueExpression ve = getValueExpression("submittedControlId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSubmittedControlId(String _submittedControlId){
this._submittedControlId = _submittedControlId;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[4];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_renderRegionOnly);
state[2] = Boolean.valueOf(_renderRegionOnlySet);
state[3] = _submittedControlId;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_renderRegionOnly = ((Boolean)states[1]).booleanValue();
		_renderRegionOnlySet = ((Boolean)states[2]).booleanValue();
		_submittedControlId = (String)states[3];;
	
}

}
