/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.component;

import javax.faces.component.UIComponentBase;
import javax.faces.el.MethodBinding;

/**
 * JSF component class
 *
 */
public abstract class UIPaint2D extends UIComponentBase {
	public static final String COMPONENT_TYPE = "org.richfaces.Paint2D";

	/**
	 * Getter for property Paint methodBinding, implementation will be generated by
	 * components-generator
	 * @return property value
	 */
	public abstract MethodBinding getPaint();

	/**
	 * Setter for property Paint methodBinding, implementation will be generated by
	 * components-generator
	 * @param newvalue - new property value
	 */
	public abstract void setPaint(MethodBinding newvalue);

	/**
	 * Getter for property cache support, implementation will be generated by
	 * components-generator
	 * @return property value
	 */
	public abstract boolean isCacheable();

	/**
	 * Setter for property cache support, implementation will be generated by
	 * components-generator
	 * @param newvalue - new property value
	 */
	public abstract void setCacheable(boolean newvalue);

	/**
	 * Getter for property image width, implementation will be generated by
	 * components-generator
	 * @return property value
	 */
	public abstract int getWidth();

	/**
	 * Setter for property image width, implementation will be generated by
	 * components-generator
	 * @param newvalue - new property value
	 */
	public abstract void setWidth(int newvalue);

	/**
	 * Getter for property image height, implementation will be generated by
	 * components-generator
	 * @return property value
	 */
	public abstract int getHeight();

	/**
	 * Setter for property image height, implementation will be generated by
	 * components-generator
	 * @param newvalue - new property value
	 */
	public abstract void setHeight(int newvalue);

	/**
	 * Getter for property output format of image ( suport gif,jpeg,png), implementation will be generated by
	 * components-generator
	 * @return property value
	 */
	public abstract String getFormat();

	/**
	 * Setter for property output format of image ( suport gif,jpeg,png), implementation will be generated by
	 * components-generator
	 * @param newvalue - new property value
	 */
	public abstract void setFormat(String newvalue);

	/**
	 * Getter for property Data to store in URL and passed to pain method. can be used as cache key or parameter for image generation., implementation will be generated by
	 * components-generator
	 * @return property value
	 */
	public abstract Object getData();

	/**
	 * Setter for property Data to store in URL and passed to pain method. can be used as cache key or parameter for image generation., implementation will be generated by
	 * components-generator
	 * @param newvalue - new property value
	 */
	public abstract void setData(Object newvalue);

	/**
	 * Getter for property bgcolor - background color of painted image
	 * @return
	 */
	public abstract String getBgcolor();

	/**
	 * Setter for property bgcolor - background color of painted image
	 * @param color - 
	 */
	public abstract void setBgcolor(String color);

}
