/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.richfaces.component.util.HtmlUtil;
import java.util.List;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
//
//
//


import org.richfaces.renderkit.ComboBoxBaseRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.ComboBoxRenderer
 */
public class ComboBoxRenderer extends ComboBoxBaseRenderer {

	public ComboBoxRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/combobox.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js")
						,
				getResource("scripts/comboboxUtils.js")
						,
				getResource("scripts/combolist.js")
						,
				getResource("scripts/combobox.js")
						,
				getResource("scripts/comboboxstyles.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/utils.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIComboBox.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIComboBox component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);

		
            Boolean disabled = (Boolean) component.getAttributes().get("disabled");
            variables.setVariable("disabled", disabled);
            
            String listHeight = (String) component.getAttributes().get("listHeight");
			if (listHeight == null || listHeight.length() == 0 || listHeight.trim().startsWith("0")) {
				listHeight = "200px";
			} else {
				listHeight = HtmlUtil.qualifySize(listHeight);
			}
			variables.setVariable("listHeight", listHeight);
		
			    	
	    	String width = (String) component.getAttributes().get("width");
	    	String correction = null;
	    	if (width == null || (width.length() == 0) || (width.trim().startsWith("0")) ) {
	    	    width = "150px";
	    	     
	    	} else {
	    		width = HtmlUtil.qualifySize(width);
	    	}
	    	
	    	correction =  width.substring(0,width.indexOf("px"));  
    	    correction = (Integer.parseInt(correction) - 10) + "px";
	    	
	    	variables.setVariable("width", width);
	    	variables.setVariable("correction", correction);
	    	
	    	String listWidth = (String) component.getAttributes().get("listWidth");
	    	
	    	if (listWidth == null || listWidth.length() == 0 || listWidth.trim().startsWith("0")) {
	    		listWidth = width;	    	   		
	    	} else {
	    		listWidth = HtmlUtil.qualifySize(listWidth);
	    	}
	    	variables.setVariable("listWidth", listWidth);
	    	 
	    	
	    	String inputSize = (String) component.getAttributes().get("inputSize");
	    	variables.setVariable("inputSize", inputSize);
	    	
			Object value = component.getSubmittedValue();
			if (value == null) {
			    value = component.getAttributes().get("value");    
			}

       		String valueStyle = "rich-combobox-font-inactive";	
	    	value = getConvertedStringValue(context, component,value);
	    	if ("".equals(value)) {
				valueStyle = "rich-combobox-font-disabled";
	    	} 
	    	variables.setVariable("value", value);
	    	
			variables.setVariable("valueStyle", valueStyle);

	      	Object styleClass = component.getAttributes().get("styleClass");
	    	variables.setVariable("styleClass", styleClass);
	    	
	    	Object style = component.getAttributes().get("style");
	    	variables.setVariable("style", style);
	    		    	
	    	String buttonIcon = (String)component.getAttributes().get("buttonIcon");
    		if (!"".equals(buttonIcon)) {
    			buttonIcon = "url('" + getResource(buttonIcon).getUri(context, component) + "')";
    		}
    		variables.setVariable("buttonIcon", buttonIcon);
    		
    		String buttonIconDisabled = (String)component.getAttributes().get("buttonIconDisabled");
    		if (!"".equals(buttonIconDisabled)) {
    			buttonIconDisabled = "url('" +  getResource(buttonIconDisabled).getUri(context, component) + "')";
    		}
    		variables.setVariable("buttonIconDisabled", buttonIconDisabled);
    		
    		String buttonIconInactive = (String)component.getAttributes().get("buttonIconInactive");
    		if (!"".equals(buttonIconInactive)) {
    			buttonIconInactive = "url('" + getResource(buttonIconInactive).getUri(context, component) + "')";
    		}
       		variables.setVariable("buttonIconInactive", buttonIconInactive);
       		variables.setVariable("enableManualInput", !component.isEnableManualInput());
		
    
variables.setVariable("spacer", getResource( "images/spacer.gif" ).getUri(context, component) );

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", clientId );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-font rich-combobox " + convertToString(variables.getVariable("styleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "combobox" );
						getUtils().writeAttribute(writer, "style", "width:" + convertToString(variables.getVariable("width")) + ";" + convertToString(variables.getVariable("style")) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "dir" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-list-cord" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-font rich-combobox-shell" );
						getUtils().writeAttribute(writer, "style", "width:" + convertToString(variables.getVariable("width")) + ";" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("valueStyle")) + " rich-combobox-input-inactive  " + convertToString(component.getAttributes().get("inputInactiveClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("disabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "comboboxField" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "comboboxField" );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("enableManualInput") );
						getUtils().writeAttribute(writer, "style", "width:" + convertToString(variables.getVariable("correction")) + "; " + convertToString(component.getAttributes().get("inputInactiveStyle")) );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", variables.getVariable("value") );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-font-inactive rich-combobox-button-background rich-combobox-button-inactive" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "comboBoxButtonBG" );
						getUtils().writeAttribute(writer, "readonly", "true" );
						getUtils().writeAttribute(writer, "tabindex", "-1" );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-font-inactive rich-combobox-button-icon-inactive rich-combobox-button-inactive " + convertToString(variables.getVariable("buttonInactiveClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("disabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "comboboxButton" );
						getUtils().writeAttribute(writer, "readonly", "true" );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("buttonStyle")) + "; background-image: " + convertToString(variables.getVariable("buttonIconInactive")) + ";" );
						getUtils().writeAttribute(writer, "tabindex", "-1" );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-strut rich-combobox-font" );
						getUtils().writeAttribute(writer, "style", "width:" + convertToString(variables.getVariable("correction")) );
			
writer.writeText(convertToString("Strut"),null);

writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-list-cord " + convertToString(component.getAttributes().get("listClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "listParent" );
						getUtils().writeAttribute(writer, "style", "display:none; " + convertToString(component.getAttributes().get("listStyle")) + "; position:absolute;z-index:1000;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-shadow" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "shadow" );
			
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-shadow-tl" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "1" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "10" );
			
writer.endElement("img");
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-shadow-tr" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "10" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "1" );
			
writer.endElement("img");
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("td");
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-shadow-bl" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "10" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "1" );
			
writer.endElement("img");
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-shadow-br" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "10" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "10" );
			
writer.endElement("img");
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-list-position" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "listPosition" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-list-decoration" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "listDecoration" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-combobox-list-scroll" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "list" );
			
writer.endElement("div");
writer.endElement("div");
writer.endElement("div");
writer.endElement("div");

	
	    variables.setVariable("hiddenValue", value);
	 
	
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "comboboxValue" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
			
writer.endElement("input");
writer.endElement("div");
java.util.HashMap classes = new java.util.HashMap();
	getUtils().addToScriptHash(classes, "normal", component.getAttributes().get("buttonInactiveClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(classes, "active", component.getAttributes().get("buttonClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(classes, "disabled", component.getAttributes().get("buttonDisabledClass"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap style1 = new java.util.HashMap();
	getUtils().addToScriptHash(style1, "normal", component.getAttributes().get("buttonInactiveStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(style1, "active", component.getAttributes().get("buttonStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(style1, "disabled", component.getAttributes().get("buttonDisabledStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap button = new java.util.HashMap();
	getUtils().addToScriptHash(button, "classes", classes,  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(button, "style", style1,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap style2 = new java.util.HashMap();
	getUtils().addToScriptHash(style2, "normal", variables.getVariable("buttonIconInactive"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(style2, "active", variables.getVariable("buttonIcon"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(style2, "disabled", variables.getVariable("buttonIconDisabled"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap buttonicon = new java.util.HashMap();
	getUtils().addToScriptHash(buttonicon, "style", style2,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap classes2 = new java.util.HashMap();
	getUtils().addToScriptHash(classes2, "normal", component.getAttributes().get("inputInactiveClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(classes2, "active", component.getAttributes().get("inputClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(classes2, "disabled", component.getAttributes().get("inputDisabledClass"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap style3 = new java.util.HashMap();
	getUtils().addToScriptHash(style3, "normal", component.getAttributes().get("inputInactiveStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(style3, "active", component.getAttributes().get("inputStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(style3, "disabled", component.getAttributes().get("inputDisabledStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap field = new java.util.HashMap();
	getUtils().addToScriptHash(field, "classes", classes2,  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(field, "style", style3,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap classes3 = new java.util.HashMap();
	getUtils().addToScriptHash(classes3, "active", component.getAttributes().get("listClass"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap style4 = new java.util.HashMap();
	getUtils().addToScriptHash(style4, "active", component.getAttributes().get("listStyle"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap list = new java.util.HashMap();
	getUtils().addToScriptHash(list, "classes", classes3,  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(list, "style", style4,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap item = new java.util.HashMap();
	getUtils().addToScriptHash(item, "normal", component.getAttributes().get("itemClass"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(item, "selected", component.getAttributes().get("itemSelectedClass"),  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap combolist = new java.util.HashMap();
	getUtils().addToScriptHash(combolist, "list", list,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(combolist, "item", item,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap userStyles = new java.util.HashMap();
	getUtils().addToScriptHash(userStyles, "button", button,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(userStyles, "buttonicon", buttonicon,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(userStyles, "field", field,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(userStyles, "combolist", combolist,  null , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap listOptions = new java.util.HashMap();
	getUtils().addToScriptHash(listOptions, "listWidth", variables.getVariable("listWidth"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(listOptions, "listHeight", variables.getVariable("listHeight"),  "200px" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(listOptions, "itemsText", getItems(context,component),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(listOptions, "onlistcall", component.getAttributes().get("onlistcall"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(listOptions, "onlistclose", component.getAttributes().get("onlistclose"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);

	getUtils().addToScriptHash(listOptions, "selectFirstOnUpdate", component.getAttributes().get("selectFirstOnUpdate"),  "true" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(listOptions, "showDelay", component.getAttributes().get("showDelay"),  "0" , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(listOptions, "hideDelay", component.getAttributes().get("hideDelay"),  "0" , ScriptHashVariableWrapper.DEFAULT);

java.util.HashMap fields = new java.util.HashMap();
	getUtils().addToScriptHash(fields, "directInputSuggestions", component.getAttributes().get("directInputSuggestions"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(fields, "defaultLabel", component.getAttributes().get("defaultLabel"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(fields, "disabled", variables.getVariable("disabled"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "filterNewValues", component.getAttributes().get("filterNewValues"),  "true" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(fields, "onselect", component.getAttributes().get("onselect"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);
	getUtils().addToScriptHash(fields, "onchange", component.getAttributes().get("onchange"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);

java.util.HashMap options = new java.util.HashMap();
	getUtils().addToScriptHash(options, "userStyles", userStyles,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "listOptions", listOptions,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "fields", fields,  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "value", variables.getVariable("value"),  null , ScriptHashVariableWrapper.DEFAULT);

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new Richfaces.ComboBox(\"" + convertToString(clientId) + "\""),null);

if ( Boolean.valueOf( String.valueOf( ( !  getUtils().isEmpty( options )  ) ) ).booleanValue() ) {


writer.writeText(convertToString(","),null);

org.ajax4jsf.javascript.ScriptUtils.writeToStream(writer, options);

}
writer.writeText(convertToString(");"),null);

writer.endElement("script");
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIComboBox)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
