/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxOutput;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.RichMessageLevelHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIRichMessages
extends UIMessages
implements AjaxOutput {
    public static final String COMPONENT_TYPE = "org.richfaces.component.RichMessages";
    private String forVal = null;
    private boolean updated = false;
    private boolean ajaxRendered = true;
    private List<FacesMessageWithId> renderedMessages;
    private Object[] values;

    public String getFor() {
        if (this.forVal != null) {
            return this.forVal;
        }
        ValueExpression ve = this.getValueExpression("for");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setFor(String newFor) {
        this.forVal = newFor;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isAjaxRendered() {
        return this.ajaxRendered;
    }

    public void setAjaxRendered(boolean ajaxRendered) {
        this.ajaxRendered = ajaxRendered;
    }

    public Iterator<FacesMessage> getMessages(FacesContext context) {
        String forInputId = this.getFor();
        if (null == this.renderedMessages || null != forInputId) {
            List<String> severenities = this.getSeverenities();
            this.renderedMessages = new ArrayList<FacesMessageWithId>();
            if (this.isGlobalOnly()) {
                this.addMessagesForId(context, null, severenities);
            } else if (null != forInputId) {
                UIComponent componentFor = RendererUtils.getInstance().findComponentFor(context, (UIComponent)this, forInputId);
                if (null != componentFor) {
                    this.addMessagesForId(context, componentFor.getClientId(context), severenities);
                }
            } else {
                Iterator clientIdsWithMessages = context.getClientIdsWithMessages();
                while (clientIdsWithMessages.hasNext()) {
                    this.addMessagesForId(context, (String)clientIdsWithMessages.next(), severenities);
                }
            }
        }
        final Iterator<FacesMessageWithId> iterator = this.renderedMessages.iterator();
        return new Iterator<FacesMessage>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FacesMessage next() {
                return ((FacesMessageWithId)iterator.next()).getMessage();
            }

            @Override
            public void remove() {
            }
        };
    }

    public void updateMessages(FacesContext context, String forId) {
        this.updated = true;
        if (null == this.renderedMessages) {
            this.renderedMessages = new ArrayList<FacesMessageWithId>();
        } else {
            Iterator<FacesMessageWithId> renderedMessageIterator = this.renderedMessages.iterator();
            while (renderedMessageIterator.hasNext()) {
                String clientId = renderedMessageIterator.next().getClientId();
                if ((null != forId || null != clientId) && (null == forId || !forId.equals(clientId))) continue;
                renderedMessageIterator.remove();
            }
        }
        this.addMessagesForId(context, forId, this.getSeverenities());
    }

    protected void addMessagesForId(FacesContext context, String forId, List<String> severenities) {
        if (this.isGlobalOnly() && forId != null) {
            return;
        }
        Iterator messages = context.getMessages(forId);
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (severenities.size() != 0 && !severenities.contains("ALL") && !this.isApplicableMessage(severenities, message)) continue;
            this.renderedMessages.add(new FacesMessageWithId(forId, message));
        }
    }

    protected boolean isApplicableMessage(List<String> severenities, FacesMessage message) {
        if (severenities.size() == 0 || severenities.contains("ALL")) {
            return true;
        }
        AjaxContext ac = AjaxContext.getCurrentInstance((FacesContext)FacesContext.getCurrentInstance());
        if (ac.isAjaxRequest() && !this.isAjaxRendered()) {
            return false;
        }
        FacesMessage.Severity severity = message.getSeverity();
        for (Object key : FacesMessage.VALUES_MAP.keySet()) {
            FacesMessage.Severity sev = (FacesMessage.Severity)FacesMessage.VALUES_MAP.get(key);
            if (0 != sev.compareTo((Object)severity)) continue;
            return severenities.contains(((String)key).toUpperCase(Locale.ENGLISH));
        }
        return false;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isUpdated()) {
            this.setRenderedMessages(null);
        }
        super.encodeBegin(context);
    }

    public abstract String getLevel();

    public abstract void setLevel(String var1);

    public abstract String getMinLevel();

    public abstract void setMinLevel(String var1);

    public List<String> getSeverenities() {
        return RichMessageLevelHelper.getSeverenities((UIComponent)this);
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[4];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.forVal;
        this.values[2] = this.ajaxRendered;
        this.values[3] = UIRichMessages.saveAttachedState((FacesContext)context, this.getRenderedMessages());
        return this.values;
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.forVal = (String)this.values[1];
        this.ajaxRendered = (Boolean)this.values[2];
        this.setRenderedMessages((List)UIRichMessages.restoreAttachedState((FacesContext)context, (Object)this.values[3]));
    }

    protected List<FacesMessageWithId> getRenderedMessages() {
        return this.renderedMessages;
    }

    protected void setRenderedMessages(List<FacesMessageWithId> renderedMessages) {
        this.renderedMessages = renderedMessages;
    }

    public static class FacesMessageWithId
    implements Serializable {
        private FacesMessage message;
        private String clientId;

        public FacesMessageWithId(String clientId, FacesMessage message) {
            this.message = message;
            this.clientId = clientId;
        }

        public FacesMessage getMessage() {
            return this.message;
        }

        public String getClientId() {
            return this.clientId;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            if (this.clientId != null) {
                out.writeBoolean(true);
                out.writeUTF(this.clientId);
            } else {
                out.writeBoolean(false);
            }
            out.writeInt(this.message.getSeverity().getOrdinal());
            String summary = this.message.getSummary();
            if (summary != null) {
                out.writeBoolean(true);
                out.writeUTF(summary);
            } else {
                out.writeBoolean(false);
            }
            String detail = this.message.getDetail();
            if (detail != null) {
                out.writeBoolean(true);
                out.writeUTF(detail);
            } else {
                out.writeBoolean(false);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (in.readBoolean()) {
                this.clientId = in.readUTF();
            }
            FacesMessage.Severity severity = FacesMessage.SEVERITY_INFO;
            int ordinal = in.readInt();
            if (ordinal >= 0 && ordinal < FacesMessage.VALUES.size()) {
                severity = (FacesMessage.Severity)FacesMessage.VALUES.get(ordinal);
            }
            String summary = null;
            if (in.readBoolean()) {
                summary = in.readUTF();
            }
            String detail = null;
            if (in.readBoolean()) {
                detail = in.readUTF();
            }
            this.message = new FacesMessage(severity, summary, detail);
        }
    }
}

