/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.util.HashSet;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.richfaces.component.UIScrollableDataTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollableDataTableRendererState {
    public static final String DATA_GRID_RENDERER_STATE = ScrollableDataTableRendererState.class.getName();
    private boolean fake;
    private Set<String> ids = new HashSet<String>();
    private String[] rowClasses;
    private int rowClassesSize;
    private String[] columnClasses;
    private int columnClassesSize;
    private int _rowIndex = 0;
    private int _cellIndex = 0;
    private int _columns = 0;
    private Integer sepOffset;
    private String _cell_id_prefix;
    private int sumWidth = 0;
    private boolean header = false;
    private String _column_type;
    private int _frozenColumnCount = -1;
    private AjaxContext ajaxContext;
    private String part;
    private boolean _frozenPart = false;
    private ResponseWriter writer;
    private UIScrollableDataTable _grid;
    private String clientId;
    private String _cachedClientId;
    private ScrollableDataTableRendererState _previousState = null;
    private Object rowKey;
    private int rows;
    private static final long serialVersionUID = 2129605586975025578L;
    private StringBuffer buffer = new StringBuffer();

    public static ScrollableDataTableRendererState getRendererState(FacesContext context) throws FacesException {
        if (null == context) {
            throw new NullPointerException("Context for grid state is null");
        }
        ScrollableDataTableRendererState state = (ScrollableDataTableRendererState)context.getExternalContext().getRequestMap().get(DATA_GRID_RENDERER_STATE);
        return state;
    }

    public static ScrollableDataTableRendererState createState(FacesContext context, UIScrollableDataTable grid) {
        if (null == context) {
            throw new NullPointerException("Context for grid state is null");
        }
        ScrollableDataTableRendererState oldState = ScrollableDataTableRendererState.getRendererState(context);
        ScrollableDataTableRendererState state = new ScrollableDataTableRendererState(context, oldState, grid);
        state.setColumnClasses(grid.getAttributes().get("columnClasses"));
        state.setRowClasses(grid.getAttributes().get("rowClasses"));
        context.getExternalContext().getRequestMap().put(DATA_GRID_RENDERER_STATE, state);
        return state;
    }

    public static void restoreState(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("Context for grid state is null");
        }
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (null == state) {
            throw new FacesException("State for current grid not saved in context");
        }
        ScrollableDataTableRendererState previsiosState = state.getPreviousState();
        if (null != previsiosState) {
            context.getExternalContext().getRequestMap().put(DATA_GRID_RENDERER_STATE, previsiosState);
        } else {
            context.getExternalContext().getRequestMap().remove(DATA_GRID_RENDERER_STATE);
        }
    }

    public ScrollableDataTableRendererState(FacesContext context, ScrollableDataTableRendererState previsiosState, UIScrollableDataTable grid) {
        this._grid = grid;
        this.clientId = this._cachedClientId = grid.getClientId(context);
        this._previousState = previsiosState;
        this.rows = grid.getRows();
    }

    public String getCurrentCellId(FacesContext context) {
        return this.getGrid().getClientId(context) + ':' + "row" + this.getRowIndex() + ':' + "col" + this.getCellIndex();
    }

    public int getCellIndex() {
        return this._cellIndex;
    }

    public void setCellIndex(int cellIndex) {
        this._cellIndex = cellIndex;
    }

    public int nextCell() {
        return ++this._cellIndex;
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumns(int columns) {
        this._columns = columns;
    }

    public UIScrollableDataTable getGrid() {
        return this._grid;
    }

    public void setGrid(UIScrollableDataTable grid) {
        this._grid = grid;
    }

    public ScrollableDataTableRendererState getPreviousState() {
        return this._previousState;
    }

    public void setPreviousState(ScrollableDataTableRendererState previsiosState) {
        this._previousState = previsiosState;
    }

    public int getRowIndex() {
        if (this.rows != 0 && this._rowIndex >= this.rows) {
            this._rowIndex = 0;
        }
        return this._rowIndex;
    }

    public int nextRow() {
        ++this._rowIndex;
        return this._rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this._rowIndex = rowIndex;
    }

    public String getCachedClientId() {
        return this._cachedClientId;
    }

    public StringBuffer getBuffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    public Object getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(Object rowKey) {
        this.rowKey = rowKey;
    }

    public boolean isFrozenColumn() {
        return this._frozenColumnCount > 0;
    }

    public void setFrozenColumnCount(int columnCount) {
        this._frozenColumnCount = columnCount;
    }

    public int getFrozenColumnCount() {
        return this._frozenColumnCount;
    }

    public boolean isFrozenPart() {
        return this._frozenPart;
    }

    public void setFrozenPart(boolean part) {
        this._frozenPart = part;
    }

    public String getCellIdPrefix() {
        return this._cell_id_prefix;
    }

    public void setCellIdPrefix(String _id_prefix) {
        this._cell_id_prefix = _id_prefix;
    }

    public String getColumnType() {
        return this._column_type;
    }

    public void setColumType(String _column_type) {
        this._column_type = _column_type;
    }

    public AjaxContext getAjaxContext() {
        return this.ajaxContext;
    }

    public void setAjaxContext(AjaxContext ajaxContext) {
        this.ajaxContext = ajaxContext;
    }

    public ResponseWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ResponseWriter writer) {
        this.writer = writer;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public int getSumWidth() {
        return this.sumWidth;
    }

    public void setSumWidth(int sumWidth) {
        this.sumWidth = sumWidth;
    }

    public Integer getSepOffset() {
        return this.sepOffset;
    }

    public void setSepOffset(Integer sepOffset) {
        this.sepOffset = sepOffset;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public String getColumnHeaderClass() {
        return "";
    }

    public String getColumnClass() {
        return this.getColumnClass(this.getCellIndex());
    }

    public String getColumnClass(int index) {
        if (this.columnClasses != null) {
            return this.columnClasses[index % this.columnClassesSize];
        }
        return "";
    }

    public void setColumnClasses(Object columnClasses) {
        if (columnClasses != null) {
            this.columnClasses = ((String)columnClasses).split(",");
            this.columnClassesSize = this.columnClasses.length;
        }
    }

    public String getRowClass() {
        return this.getRowClass(this.getRowIndex()) + (this.isFake() ? " rich-sdt-fake-r " : "");
    }

    private String getRowClass(int index) {
        if (this.rowClasses != null) {
            return this.rowClasses[index % this.rowClassesSize];
        }
        return "";
    }

    public void setRowClasses(Object rowClasses) {
        if (rowClasses != null) {
            this.rowClasses = ((String)rowClasses).split(",");
            this.rowClassesSize = this.rowClasses.length;
        }
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public void addId(String id) {
        this.ids.add(id);
    }
}

