/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.runtime.Comparator;

public abstract class FlatHashTable$class {
    public static void $init$(FlatHashTable $this) {
        $this.table_$eq((Object[])($this.initialSize() != 0 ? new Object[$this.initialSize()] : null));
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.initialSize()));
    }

    private static final boolean precedes$0(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i > j ? i - j > d : j - i < d;
    }

    public static void clear(FlatHashTable $this) {
        int i = $this.table().length - 1;
        while (true) {
            if (i < 0) {
                $this.tableSize_$eq(0);
                return;
            }
            $this.table()[i] = null;
            --i;
        }
    }

    private static int newThreshold(FlatHashTable $this, int size) {
        float lf = $this.loadFactor();
        Predef$.MODULE$.assert(lf < 0.5f, "loadFactor too large; must be < 0.5");
        return (int)((float)size * lf);
    }

    public static final int index(FlatHashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    public static final int improve(FlatHashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(FlatHashTable $this, Object elem) {
        return elem.hashCode();
    }

    private static void checkConsistent(FlatHashTable $this) {
        Predef$.MODULE$.intWrapper(0).until($this.table().length).foreach(new FlatHashTable$.anonfun.0($this));
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.table().length));
        int i = 0;
        while (i < oldtable.length) {
            Object entry = oldtable[i];
            if (!Comparator.equals(null, entry)) {
                $this.addEntry(entry);
            }
            ++i;
        }
        return;
    }

    public static Object elements(FlatHashTable $this) {
        return new FlatHashTable$.anon.0($this);
    }

    public static void removeEntry(FlatHashTable $this, Object elem) {
        block3: {
            int h = $this.index($this.elemHashCode(elem));
            Object entry = $this.table()[h];
            while (true) {
                if (Comparator.equals(null, entry)) break block3;
                if (Comparator.equals(entry, elem)) break;
                h = (h + 1) % $this.table().length;
                entry = $this.table()[h];
            }
            int h0 = h;
            int h1 = (h0 + 1) % $this.table().length;
            while (true) {
                if (Comparator.equals(null, $this.table()[h1])) break;
                int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                if (h2 != h1 && FlatHashTable$class.precedes$0($this, h2, h0)) {
                    $this.table()[h0] = $this.table()[h1];
                    h0 = h1;
                }
                h1 = (h1 + 1) % $this.table().length;
            }
            $this.table()[h0] = null;
            $this.tableSize_$eq($this.tableSize() - 1);
            return;
        }
    }

    public static void addEntry(FlatHashTable $this, Object elem) {
        block2: {
            int h = $this.index($this.elemHashCode(elem));
            Object entry = $this.table()[h];
            while (true) {
                if (Comparator.equals(null, entry)) break block2;
                if (Comparator.equals(entry, elem)) break;
                h = (h + 1) % $this.table().length;
                entry = $this.table()[h];
            }
            return;
        }
        $this.table()[h] = elem;
        $this.tableSize_$eq($this.tableSize() + 1);
        if ($this.tableSize() >= $this.threshold()) {
            FlatHashTable$class.growTable($this);
        }
    }

    public static boolean containsEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (true) {
            if (Comparator.equals(null, entry) || Comparator.equals(entry, elem)) break;
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return !Comparator.equals(null, entry);
    }

    public static Option findEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (true) {
            if (Comparator.equals(null, entry) || Comparator.equals(entry, elem)) break;
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return !Comparator.equals(null, entry) ? new Some(entry) : None$.MODULE$;
    }

    public static int size(FlatHashTable $this) {
        return $this.tableSize();
    }

    public static int initialSize(FlatHashTable $this) {
        return 16;
    }

    public static float loadFactor(FlatHashTable $this) {
        return 0.45f;
    }
}

