/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static void $init$(FlatHashTable $this) {
        $this.table_$eq($this.initialSize() == 0 ? null : new Object[$this.initialSize()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.initialSize()));
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void clear(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
    }

    private static int newThreshold(FlatHashTable $this, int size2) {
        int lf = $this.loadFactor();
        Predef$.MODULE$.assert(lf < $this.loadFactorDenum() / 2, "loadFactor too large; must be < 0.5");
        return (int)((long)size2 * (long)lf / (long)$this.loadFactorDenum());
    }

    public static final int index(FlatHashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    public static final int improve(FlatHashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(FlatHashTable $this, Object elem2) {
        return elem2.hashCode();
    }

    private static void checkConsistent(FlatHashTable $this) {
        Predef$.MODULE$.intWrapper(0).until($this.table().length).foreach(new FlatHashTable$.anonfun.checkConsistent.1($this));
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (BoxesRunTime.equals(null, entry)) continue;
            $this.addEntry(entry);
        }
    }

    public static Object elements(FlatHashTable $this) {
        return new FlatHashTable$.anon.1($this);
    }

    public static Option removeEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            if (BoxesRunTime.equals(null, entry)) {
                return None$.MODULE$;
            }
            if (BoxesRunTime.equals(entry, elem2)) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while (true) {
                    if (BoxesRunTime.equals(null, $this.table()[h1])) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        return new Some<Object>(entry);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static boolean addEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            if (BoxesRunTime.equals(null, entry)) {
                $this.table()[h] = elem2;
                $this.tableSize_$eq($this.tableSize() + 1);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            if (BoxesRunTime.equals(entry, elem2)) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static boolean containsEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            if (BoxesRunTime.equals(null, entry) || BoxesRunTime.equals(entry, elem2)) {
                return !BoxesRunTime.equals(null, entry);
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static Option findEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            if (BoxesRunTime.equals(null, entry) || BoxesRunTime.equals(entry, elem2)) {
                return BoxesRunTime.equals(null, entry) ? None$.MODULE$ : new Some<Object>(entry);
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static int size(FlatHashTable $this) {
        return $this.tableSize();
    }

    public static int initialSize(FlatHashTable $this) {
        return 16;
    }

    public static final int loadFactorDenum(FlatHashTable $this) {
        return 1000;
    }

    public static int loadFactor(FlatHashTable $this) {
        return 450;
    }
}

