package dotty.tools.dotc.core

import dotty.tools.tasty.TastyFormat

/** The possible tags of a NameKind */
object NameTags extends TastyFormat.NameTags {

  inline val FLATTENED = 5       // A flat name, generated by Flatten

  inline val TRAITSETTER = 6     // A Scala-2 trait setter, generated by AugmentScala2Traits

  inline val OUTERSELECT = 13    // A name `<num>_outer`, used by the inliner to indicate an
                                // outer accessor that will be filled in by ExplicitOuter.
                                // <num> indicates the number of hops needed to select the outer field.

  inline val PROTECTEDACCESSOR = 24 // The name of a protected accesor `protected$<name>` created by ProtectedAccessors.

  inline val INITIALIZER = 26    // A mixin initializer method

  inline val FIELD = 29          // Used by Memoize to tag the name of a class member field.

  inline val EXTMETH = 30        // Used by ExtensionMethods for the name of an extension method
                                // implementing a value class method.

  inline val ADAPTEDCLOSURE = 31 // Used in Erasure to adapt closures over primitive types.

  inline val DIRECT = 32         // Used to define implementations of methods with
                                // erased context function results that can override some
                                // other method.

  inline val PARAMACC = 33       // Used for a private parameter alias

  inline val SETTER = 34         // A synthesized += suffix.

  // Name of type variables created by `ConstraintHandling#LevelAvoidMap`.
  final val AVOIDUPPER = 35
  final val AVOIDLOWER = 36
  final val AVOIDBOTH = 37

  inline val EXPLICITFIELD = 38  // An explicitly named field, introduce to avoid a clash
                                 // with a regular field of the underlying name

  def nameTagToString(tag: Int): String = tag match {
    case UTF8 => "UTF8"
    case QUALIFIED => "QUALIFIED"
    case FLATTENED => "FLATTENED"
    case EXPANDED => "EXPANDED"
    case EXPANDPREFIX => "EXPANDPREFIX"
    case TRAITSETTER => "TRAITSETTER"
    case UNIQUE => "UNIQUE"
    case DEFAULTGETTER => "DEFAULTGETTER"
    case OUTERSELECT => "OUTERSELECT"

    case SUPERACCESSOR => "SUPERACCESSOR"
    case INLINEACCESSOR => "INLINEACCESSOR"
    case PROTECTEDACCESSOR => "PROTECTEDACCESSOR"
    case INITIALIZER => "INITIALIZER"
    case FIELD => "FIELD"
    case EXTMETH => "EXTMETH"
    case DIRECT => "DIRECT"
    case PARAMACC => "PARAMACC"
    case ADAPTEDCLOSURE => "ADAPTEDCLOSURE"
    case OBJECTCLASS => "OBJECTCLASS"

    case SIGNED => "SIGNED"
    case TARGETSIGNED => "TARGETSIGNED"
  }
}
