/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.Changes;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.FileHash;
import xsbti.compile.InvalidationProfiler;

public interface ExternalHooks {
    public Optional<Lookup> getExternalLookup();

    public Optional<ClassFileManager> getExternalClassFileManager();

    default public GetProvenance getProvenance() {
        return NoProvenance.INSTANCE;
    }

    public ExternalHooks withExternalClassFileManager(ClassFileManager var1);

    public ExternalHooks withExternalLookup(Lookup var1);

    default public ExternalHooks withGetProvenance(GetProvenance getProvenance) {
        return this;
    }

    default public InvalidationProfiler getInvalidationProfiler() {
        return InvalidationProfiler.EMPTY.INSTANCE;
    }

    default public ExternalHooks withInvalidationProfiler(InvalidationProfiler invalidationProfiler) {
        return this;
    }

    public static enum NoProvenance implements GetProvenance
    {
        INSTANCE;


        @Override
        public String get(Path path) {
            return "";
        }
    }

    public static interface GetProvenance {
        public String get(Path var1);
    }

    public static interface Lookup {
        public Optional<Changes<VirtualFileRef>> getChangedSources(CompileAnalysis var1);

        public Optional<Set<VirtualFileRef>> getChangedBinaries(CompileAnalysis var1);

        public Optional<Set<VirtualFileRef>> getRemovedProducts(CompileAnalysis var1);

        public boolean shouldDoIncrementalCompilation(Set<String> var1, CompileAnalysis var2);

        public Optional<FileHash[]> hashClasspath(VirtualFile[] var1);
    }
}

