/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.seedstack.coffig.Config;

@Config(value="security.web")
public class WebSecurityConfig {
    private List<UrlConfig> urls = new ArrayList<UrlConfig>();
    private XSRFConfig xsrf = new XSRFConfig();

    public List<UrlConfig> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    public WebSecurityConfig addUrl(UrlConfig urlConfig) {
        this.urls.add(urlConfig);
        return this;
    }

    public XSRFConfig xsrf() {
        return this.xsrf;
    }

    @Config(value="xsrf")
    public static class XSRFConfig {
        private String cookieName = "XSRF-TOKEN";
        private String headerName = "X-XSRF-TOKEN";
        private String algorithm = "SHA1PRNG";
        private int length = 32;

        public String getCookieName() {
            return this.cookieName;
        }

        public XSRFConfig setCookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public XSRFConfig setHeaderName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public XSRFConfig setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public int getLength() {
            return this.length;
        }

        public XSRFConfig setLength(int length) {
            this.length = length;
            return this;
        }
    }

    public static class UrlConfig {
        private String pattern = "/**";
        private List<String> filters = new ArrayList<String>();

        public String getPattern() {
            return this.pattern;
        }

        public UrlConfig setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public List<String> getFilters() {
            return Collections.unmodifiableList(this.filters);
        }

        public UrlConfig addFilters(String ... filters) {
            this.filters.addAll(Arrays.asList(filters));
            return this;
        }
    }
}

