/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.seedstack.seed.SeedException;
import org.seedstack.seed.web.security.internal.WebSecurityErrorCode;
import org.seedstack.seed.web.spi.AntiXsrfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AntiXsrfFilter
extends AdviceFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntiXsrfFilter.class);
    @Inject
    private AntiXsrfService AntiXsrfService;

    AntiXsrfFilter() {
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        try {
            this.AntiXsrfService.applyXsrfProtection((HttpServletRequest)request, (HttpServletResponse)response);
            return true;
        }
        catch (SeedException e) {
            switch ((WebSecurityErrorCode)e.getErrorCode()) {
                case MISSING_XSRF_HEADER: {
                    ((HttpServletResponse)response).sendError(403, "Missing XSRF protection token in the request");
                    return false;
                }
                case MISSING_XSRF_COOKIE: {
                    ((HttpServletResponse)response).sendError(403, "Missing XSRF protection token cookie");
                    return false;
                }
                case INVALID_XSRF_TOKEN: {
                    ((HttpServletResponse)response).sendError(403, "Request token does not match session token");
                    return false;
                }
            }
            LOGGER.error("An error occurred when applying XSRF protection", (Throwable)e);
            return false;
        }
    }

    protected void postHandle(ServletRequest request, ServletResponse response) throws Exception {
        this.AntiXsrfService.cleanXsrfProtection((HttpServletRequest)request, (HttpServletResponse)response);
    }
}

