/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.seedstack.seed.SeedException;
import org.seedstack.seed.web.security.WebSecurityConfig;
import org.seedstack.seed.web.security.internal.WebSecurityErrorCode;
import org.seedstack.seed.web.spi.AntiXsrfService;
import org.seedstack.shed.exception.ErrorCode;

class StatelessAntiXsrfService
implements AntiXsrfService {
    private static final char[] CHARSET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private final WebSecurityConfig.XSRFConfig xsrfConfig;

    @Inject
    public StatelessAntiXsrfService(WebSecurityConfig webSecurityConfig) {
        this.xsrfConfig = webSecurityConfig.xsrf();
    }

    public void applyXsrfProtection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String cookieName = this.xsrfConfig.getCookieName();
        String headerName = this.xsrfConfig.getHeaderName();
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            if (session.isNew()) {
                Cookie cookie = new Cookie(cookieName, this.generateToken());
                cookie.setHttpOnly(false);
                cookie.setPath("/");
                cookie.setMaxAge(-1);
                httpServletResponse.addCookie(cookie);
            } else {
                String cookieToken = this.extractCookieToken(cookieName, httpServletRequest);
                String requestToken = httpServletRequest.getHeader(headerName);
                if (requestToken == null) {
                    throw SeedException.createNew((ErrorCode)WebSecurityErrorCode.MISSING_XSRF_HEADER);
                }
                if (cookieToken == null) {
                    throw SeedException.createNew((ErrorCode)WebSecurityErrorCode.MISSING_XSRF_COOKIE);
                }
                int commaIndex = requestToken.indexOf(44);
                if (commaIndex != -1) {
                    requestToken = requestToken.substring(0, commaIndex).trim();
                }
                if (!cookieToken.equals(requestToken)) {
                    throw SeedException.createNew((ErrorCode)WebSecurityErrorCode.INVALID_XSRF_TOKEN);
                }
            }
        }
    }

    public void cleanXsrfProtection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session == null) {
            Cookie cookie = new Cookie(this.xsrfConfig.getCookieName(), "deleteMe");
            cookie.setHttpOnly(false);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
        }
    }

    private String extractCookieToken(String cookieName, HttpServletRequest httpServletRequest) {
        for (Cookie cookie : httpServletRequest.getCookies()) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private String generateToken() {
        String tokenAlgorithm = this.xsrfConfig.getAlgorithm();
        int tokenLength = this.xsrfConfig.getLength();
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(tokenAlgorithm);
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < tokenLength + 1; ++i) {
                sb.append(CHARSET[secureRandom.nextInt(CHARSET.length)]);
                if (i % 4 != 0 || i == 0 || i >= tokenLength) continue;
                sb.append('-');
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
    }
}

