/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.seedstack.seed.security.internal.SecurityGuiceConfigurer;
import org.seedstack.seed.web.SecurityFilter;
import org.seedstack.seed.web.security.WebSecurityConfig;
import org.seedstack.seed.web.security.internal.AntiXsrfFilter;
import org.seedstack.seed.web.security.internal.StatelessAntiXsrfService;
import org.seedstack.seed.web.security.internal.X509CertificateFilter;
import org.seedstack.seed.web.security.internal.shiro.ShiroWebModule;
import org.seedstack.seed.web.spi.AntiXsrfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSecurityModule
extends ShiroWebModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShiroWebModule.class);
    private static final Map<String, Key<? extends Filter>> DEFAULT_FILTERS = new HashMap<String, Key<? extends Filter>>();
    private final String applicationName;
    private final WebSecurityConfig securityConfig;
    private final Collection<Class<? extends Filter>> customFilters;
    private final SecurityGuiceConfigurer securityGuiceConfigurer;

    WebSecurityModule(ServletContext servletContext, WebSecurityConfig securityConfig, Collection<Class<? extends Filter>> customFilters, String applicationName, SecurityGuiceConfigurer securityGuiceConfigurer) {
        super(servletContext);
        this.securityConfig = securityConfig;
        this.customFilters = customFilters;
        this.applicationName = applicationName;
        this.securityGuiceConfigurer = securityGuiceConfigurer;
    }

    @Override
    protected void configureShiroWeb() {
        for (WebSecurityConfig.UrlConfig urlConfig : this.securityConfig.getUrls()) {
            String pattern = urlConfig.getPattern();
            List<String> filters = urlConfig.getFilters();
            LOGGER.trace("Binding {} to security filter chain {}", (Object)pattern, filters);
            this.addFilterChain(pattern, this.getFilterKeys(filters));
        }
        LOGGER.debug("{} URL(s) bound to security filters", (Object)this.securityConfig.getUrls().size());
        this.bind(WebSecurityConfig.class);
        this.bind(AntiXsrfFilter.class);
        for (Class clazz : this.customFilters) {
            if (PathMatchingFilter.class.isAssignableFrom(clazz)) continue;
            this.bind(clazz);
        }
        this.bind(AntiXsrfService.class).to(StatelessAntiXsrfService.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"shiro.applicationName")).to(this.applicationName);
        this.securityGuiceConfigurer.configure((Binder)this.binder());
        this.bind(GuiceShiroFilter.class).in(Scopes.SINGLETON);
        this.expose(AntiXsrfService.class);
    }

    private ShiroWebModule.FilterKey[] getFilterKeys(List<String> filters) {
        ShiroWebModule.FilterKey[] keys = new ShiroWebModule.FilterKey[filters.size()];
        int index = 0;
        for (String filter : filters) {
            String[] nameConfig = this.toNameConfigPair(filter);
            Key<? extends Filter> key = this.findKey(nameConfig[0]);
            if (key != null) {
                keys[index] = new ShiroWebModule.FilterKey(key, nameConfig[1] == null ? "" : nameConfig[1]);
            } else {
                this.addError("The filter [" + nameConfig[0] + "] could not be found as a default filter or as a class annotated with SecurityFilter", new Object[0]);
            }
            ++index;
        }
        return keys;
    }

    private Key<? extends Filter> findKey(String filterName) {
        Key currentKey = null;
        if (DEFAULT_FILTERS.containsKey(filterName)) {
            currentKey = DEFAULT_FILTERS.get(filterName);
        } else {
            for (Class<? extends Filter> filterClass : this.customFilters) {
                String name = filterClass.getAnnotation(SecurityFilter.class).value();
                if (!filterName.equals(name)) continue;
                currentKey = Key.get(filterClass);
            }
        }
        return currentKey;
    }

    private String[] toNameConfigPair(String token) throws ConfigurationException {
        String[] pair = token.split("\\[", 2);
        String name = StringUtils.clean((String)pair[0]);
        if (name == null) {
            throw new IllegalArgumentException("Filter name not found for filter chain definition token: " + token);
        }
        String config = null;
        if (pair.length == 2) {
            config = StringUtils.clean((String)pair[1]);
            config = config.substring(0, config.length() - 1);
            if ((config = StringUtils.clean((String)config)) != null && config.startsWith("\"") && config.endsWith("\"")) {
                String stripped = config.substring(1, config.length() - 1);
                if ((stripped = StringUtils.clean((String)stripped)) != null && stripped.indexOf(34) == -1) {
                    config = stripped;
                }
            }
        }
        return new String[]{name, config};
    }

    static {
        DEFAULT_FILTERS.put("anon", (Key<? extends Filter>)ANON);
        DEFAULT_FILTERS.put("authc", (Key<? extends Filter>)AUTHC);
        DEFAULT_FILTERS.put("authcBasic", (Key<? extends Filter>)AUTHC_BASIC);
        DEFAULT_FILTERS.put("logout", (Key<? extends Filter>)LOGOUT);
        DEFAULT_FILTERS.put("noSessionCreation", (Key<? extends Filter>)NO_SESSION_CREATION);
        DEFAULT_FILTERS.put("perms", (Key<? extends Filter>)PERMS);
        DEFAULT_FILTERS.put("port", (Key<? extends Filter>)PORT);
        DEFAULT_FILTERS.put("rest", (Key<? extends Filter>)REST);
        DEFAULT_FILTERS.put("roles", (Key<? extends Filter>)ROLES);
        DEFAULT_FILTERS.put("ssl", (Key<? extends Filter>)SSL);
        DEFAULT_FILTERS.put("user", (Key<? extends Filter>)USER);
        DEFAULT_FILTERS.put("xsrf", (Key<? extends Filter>)Key.get(AntiXsrfFilter.class));
        DEFAULT_FILTERS.put("cert", (Key<? extends Filter>)Key.get(X509CertificateFilter.class));
    }
}

