/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.PluginException;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.seedstack.seed.core.SeedRuntime;
import org.seedstack.seed.core.internal.AbstractSeedPlugin;
import org.seedstack.seed.core.internal.configuration.ConfigurationPlugin;
import org.seedstack.seed.security.internal.SecurityGuiceConfigurer;
import org.seedstack.seed.security.internal.SecurityProvider;
import org.seedstack.seed.web.SecurityFilter;
import org.seedstack.seed.web.security.WebSecurityConfig;
import org.seedstack.seed.web.security.internal.WebSecurityModule;
import org.seedstack.seed.web.spi.FilterDefinition;
import org.seedstack.seed.web.spi.ListenerDefinition;
import org.seedstack.seed.web.spi.ServletDefinition;
import org.seedstack.seed.web.spi.WebProvider;

public class WebSecurityPlugin
extends AbstractSeedPlugin
implements SecurityProvider,
WebProvider {
    private final Collection<Class<? extends Filter>> scannedFilters = new ArrayList<Class<? extends Filter>>();
    private ServletContext servletContext;
    private String applicationId;
    private WebSecurityConfig securityConfig;

    public String name() {
        return "web-security";
    }

    public void setup(SeedRuntime seedRuntime) {
        this.servletContext = (ServletContext)seedRuntime.contextAs(ServletContext.class);
    }

    public Collection<Class<?>> dependencies() {
        return Lists.newArrayList((Object[])new Class[]{ConfigurationPlugin.class});
    }

    public Collection<ClasspathScanRequest> classpathScanRequests() {
        return this.classpathScanRequestBuilder().annotationType(SecurityFilter.class).build();
    }

    public InitState initialize(InitContext initContext) {
        ConfigurationPlugin configurationPlugin = (ConfigurationPlugin)initContext.dependency(ConfigurationPlugin.class);
        this.applicationId = configurationPlugin.getApplication().getId();
        this.securityConfig = (WebSecurityConfig)this.getConfiguration(WebSecurityConfig.class, new String[0]);
        for (Class filterClass : (Collection)initContext.scannedClassesByAnnotationClass().get(SecurityFilter.class)) {
            if (Filter.class.isAssignableFrom(filterClass)) {
                this.scannedFilters.add(filterClass);
                continue;
            }
            throw new PluginException("Annotated class " + filterClass.getName() + " must implement Filter to be used in a filter chain", new Object[0]);
        }
        return InitState.INITIALIZED;
    }

    public Module provideMainSecurityModule(SecurityGuiceConfigurer securityGuiceConfigurer) {
        return this.servletContext != null ? new WebSecurityModule(this.servletContext, this.securityConfig, this.scannedFilters, this.applicationId, securityGuiceConfigurer) : null;
    }

    public Module provideAdditionalSecurityModule() {
        return null;
    }

    public List<ServletDefinition> servlets() {
        return null;
    }

    public List<FilterDefinition> filters() {
        FilterDefinition securityFilter = new FilterDefinition("security", GuiceShiroFilter.class);
        securityFilter.setPriority(1000);
        securityFilter.setAsyncSupported(true);
        securityFilter.addMappings(new FilterDefinition.Mapping[]{new FilterDefinition.Mapping(new String[]{"/*"})});
        return Lists.newArrayList((Object[])new FilterDefinition[]{securityFilter});
    }

    public List<ListenerDefinition> listeners() {
        return null;
    }
}

