/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.seedstack.seed.security.X509CertificateToken;
import org.seedstack.seed.security.internal.realms.AuthenticationTokenWrapper;

public class X509CertificateFilter
extends AuthenticatingFilter {
    private static final String OPTIONAL = "optional";
    private boolean optional;

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        X509Certificate[] certificates = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        return new AuthenticationTokenWrapper((org.seedstack.seed.security.AuthenticationToken)new X509CertificateToken(certificates));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        return this.executeLogin(request, response);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        if (this.optional) {
            return true;
        }
        try {
            ((HttpServletResponse)response).sendError(401, "A valid certificate is required to gain access");
        }
        catch (IOException e1) {
            throw new IllegalStateException(e1);
        }
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (mappedValue != null && ((String[])mappedValue).length != 0) {
            this.optional = OPTIONAL.equals(((String[])mappedValue)[0]);
        }
        Subject subject = this.getSubject(request, response);
        return subject.isAuthenticated();
    }
}

