/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal.shiro;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderWithDependencies;
import java.lang.reflect.Constructor;
import java.util.Set;

class AbstractInjectionProvider<T>
implements ProviderWithDependencies<T> {
    private Key<T> key;
    @Inject
    Injector injector;
    private InjectionPoint constructorInjectionPoint;
    private Set<Dependency<?>> dependencies;

    public AbstractInjectionProvider(Key<T> key) {
        this.key = key;
        this.constructorInjectionPoint = InjectionPoint.forConstructorOf((TypeLiteral)key.getTypeLiteral());
        ImmutableSet.Builder dependencyBuilder = ImmutableSet.builder();
        dependencyBuilder.addAll((Iterable)this.constructorInjectionPoint.getDependencies());
        for (InjectionPoint injectionPoint : InjectionPoint.forInstanceMethodsAndFields((TypeLiteral)key.getTypeLiteral())) {
            dependencyBuilder.addAll((Iterable)injectionPoint.getDependencies());
        }
        this.dependencies = dependencyBuilder.build();
    }

    public T get() {
        T t;
        Constructor<T> constructor = this.getConstructor();
        Object[] params = new Object[constructor.getParameterTypes().length];
        for (Dependency dependency : this.constructorInjectionPoint.getDependencies()) {
            params[dependency.getParameterIndex()] = this.injector.getInstance(dependency.getKey());
        }
        try {
            t = constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new ProvisionException("Could not instantiate " + this.key + "", (Throwable)e);
        }
        this.injector.injectMembers(t);
        return this.postProcess(t);
    }

    private Constructor<T> getConstructor() {
        return (Constructor)this.constructorInjectionPoint.getMember();
    }

    protected T postProcess(T t) {
        return t;
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }
}

