/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal.shiro;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderWithDependencies;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.seedstack.seed.web.security.internal.shiro.ShiroWebModule;
import org.seedstack.seed.web.security.internal.shiro.SimpleFilterChainResolver;

@Singleton
class FilterChainResolverProvider
implements ProviderWithDependencies<FilterChainResolver> {
    @Inject
    Injector injector;
    private final Map<String, ShiroWebModule.FilterKey[]> chains;
    private final Set<Dependency<?>> dependencies;
    private PatternMatcher patternMatcher = new AntPathMatcher();

    public FilterChainResolverProvider(Map<String, ShiroWebModule.FilterKey[]> chains) {
        this.chains = chains;
        ImmutableSet.Builder dependenciesBuilder = ImmutableSet.builder();
        for (String chain : chains.keySet()) {
            for (ShiroWebModule.FilterKey filterKey : chains.get(chain)) {
                dependenciesBuilder.add((Object)Dependency.get(filterKey.getKey()));
            }
        }
        this.dependencies = dependenciesBuilder.build();
    }

    @Inject(optional=true)
    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public FilterChainResolver get() {
        return new SimpleFilterChainResolver(this.chains, this.injector, this.patternMatcher);
    }
}

