/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal.shiro;

import com.google.common.collect.HashBasedTable;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.env.Environment;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.web.env.WebEnvironment;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.apache.shiro.web.filter.authc.UserFilter;
import org.apache.shiro.web.filter.authz.HttpMethodPermissionFilter;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.filter.authz.PortFilter;
import org.apache.shiro.web.filter.authz.RolesAuthorizationFilter;
import org.apache.shiro.web.filter.authz.SslFilter;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.session.NoSessionCreationFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.seedstack.seed.web.security.internal.shiro.FilterChainResolverProvider;
import org.seedstack.seed.web.security.internal.shiro.PathMatchingFilterProvider;
import org.seedstack.seed.web.security.internal.shiro.WebGuiceEnvironment;

public abstract class ShiroWebModule
extends ShiroModule {
    public static final Key<AnonymousFilter> ANON = Key.get(AnonymousFilter.class);
    public static final Key<FormAuthenticationFilter> AUTHC = Key.get(FormAuthenticationFilter.class);
    public static final Key<BasicHttpAuthenticationFilter> AUTHC_BASIC = Key.get(BasicHttpAuthenticationFilter.class);
    public static final Key<NoSessionCreationFilter> NO_SESSION_CREATION = Key.get(NoSessionCreationFilter.class);
    public static final Key<LogoutFilter> LOGOUT = Key.get(LogoutFilter.class);
    public static final Key<PermissionsAuthorizationFilter> PERMS = Key.get(PermissionsAuthorizationFilter.class);
    public static final Key<PortFilter> PORT = Key.get(PortFilter.class);
    public static final Key<HttpMethodPermissionFilter> REST = Key.get(HttpMethodPermissionFilter.class);
    public static final Key<RolesAuthorizationFilter> ROLES = Key.get(RolesAuthorizationFilter.class);
    public static final Key<SslFilter> SSL = Key.get(SslFilter.class);
    public static final Key<UserFilter> USER = Key.get(UserFilter.class);
    static final String NAME = "SHIRO";
    private final Map<String, FilterKey[]> filterChains = new LinkedHashMap<String, FilterKey[]>();
    private final ServletContext servletContext;

    public ShiroWebModule(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected final void configureShiro() {
        this.bindBeanType(TypeLiteral.get(ServletContext.class), Key.get(ServletContext.class, (Annotation)Names.named((String)NAME)));
        this.bind(Key.get(ServletContext.class, (Annotation)Names.named((String)NAME))).toInstance((Object)this.servletContext);
        this.bindWebSecurityManager((AnnotatedBindingBuilder<? super WebSecurityManager>)this.bind(WebSecurityManager.class));
        this.bindWebEnvironment((AnnotatedBindingBuilder<? super WebEnvironment>)this.bind(WebEnvironment.class));
        this.bind(GuiceShiroFilter.class).asEagerSingleton();
        this.expose(GuiceShiroFilter.class);
        this.configureShiroWeb();
        this.setupFilterChainConfigs();
        this.bind(FilterChainResolver.class).toProvider((Provider)new FilterChainResolverProvider(this.filterChains));
    }

    private void setupFilterChainConfigs() {
        HashBasedTable configs = HashBasedTable.create();
        for (Map.Entry<String, FilterKey[]> filterChain : this.filterChains.entrySet()) {
            for (int i = 0; i < filterChain.getValue().length; ++i) {
                FilterKey configKey = filterChain.getValue()[i];
                if (!configKey.getValue().isEmpty()) {
                    filterChain.getValue()[i] = configKey;
                    Key<? extends Filter> key = configKey.getKey();
                    if (!PathMatchingFilter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                        throw new ConfigurationException("Config information requires a PathMatchingFilter - can't apply to " + key.getTypeLiteral().getRawType());
                    }
                    configs.put(this.castToPathMatching(key), (Object)filterChain.getKey(), (Object)configKey.getValue());
                    continue;
                }
                if (!PathMatchingFilter.class.isAssignableFrom(configKey.getKey().getTypeLiteral().getRawType())) continue;
                configs.put(this.castToPathMatching(configKey.getKey()), (Object)filterChain.getKey(), (Object)"");
            }
        }
        for (Key filterKey : configs.rowKeySet()) {
            this.bindPathMatchingFilter(filterKey, configs.row((Object)filterKey));
        }
    }

    private <T extends PathMatchingFilter> void bindPathMatchingFilter(Key<T> filterKey, Map<String, String> configs) {
        this.bind(filterKey).toProvider(new PathMatchingFilterProvider<T>(filterKey, configs)).asEagerSingleton();
    }

    private Key<? extends PathMatchingFilter> castToPathMatching(Key<? extends Filter> key) {
        return key;
    }

    protected abstract void configureShiroWeb();

    protected final void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        this.bindWebSecurityManager(bind);
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        try {
            bind.toConstructor(DefaultWebSecurityManager.class.getConstructor(Collection.class)).asEagerSingleton();
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("This really shouldn't happen.  Either something has changed in Shiro, or there's a bug in ShiroModule.", (Throwable)e);
        }
    }

    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(ServletContainerSessionManager.class).asEagerSingleton();
    }

    protected final void bindEnvironment(AnnotatedBindingBuilder<Environment> bind) {
        this.bindWebEnvironment(bind);
    }

    protected void bindWebEnvironment(AnnotatedBindingBuilder<? super WebEnvironment> bind) {
        bind.to(WebGuiceEnvironment.class).asEagerSingleton();
    }

    protected final void addFilterChain(String pattern, FilterKey ... keys) {
        this.filterChains.put(pattern, keys);
    }

    public static class FilterKey {
        private final Key<? extends Filter> key;
        private final String value;

        public FilterKey(Key<? extends Filter> key, String value) {
            this.key = key;
            this.value = value;
        }

        Key<? extends Filter> getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }
    }
}

