/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web.security.internal.shiro;

import com.google.common.collect.Iterators;
import com.google.inject.Injector;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.util.WebUtils;
import org.seedstack.seed.web.security.internal.shiro.ShiroWebModule;
import org.seedstack.seed.web.security.internal.shiro.SimpleFilterChain;

class SimpleFilterChainResolver
implements FilterChainResolver {
    private final Map<String, ShiroWebModule.FilterKey[]> chains;
    private final Injector injector;
    private final PatternMatcher patternMatcher;

    SimpleFilterChainResolver(Map<String, ShiroWebModule.FilterKey[]> chains, Injector injector, PatternMatcher patternMatcher) {
        this.chains = chains;
        this.injector = injector;
        this.patternMatcher = patternMatcher;
    }

    public FilterChain getChain(ServletRequest request, ServletResponse response, FilterChain originalChain) {
        String path = WebUtils.getPathWithinApplication((HttpServletRequest)WebUtils.toHttp((ServletRequest)request));
        for (String pathPattern : this.chains.keySet()) {
            if (!this.patternMatcher.matches(pathPattern, path)) continue;
            return new SimpleFilterChain(originalChain, Iterators.transform((Iterator)Iterators.forArray((Object[])this.chains.get(pathPattern)), input -> (Filter)this.injector.getInstance(input.getKey())));
        }
        return null;
    }
}

