/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.web;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.seedstack.coffig.Config;
import org.seedstack.coffig.SingleValue;

@Config(value="web")
public class WebConfig {
    private boolean requestDiagnostic;
    private StaticResourcesConfig staticResources = new StaticResourcesConfig();
    private CORSConfig cors = new CORSConfig();
    private ServerConfig serverConfig = new ServerConfig();

    public boolean isRequestDiagnosticEnabled() {
        return this.requestDiagnostic;
    }

    public StaticResourcesConfig staticResources() {
        return this.staticResources;
    }

    public CORSConfig cors() {
        return this.cors;
    }

    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    @Config(value="server")
    public static class ServerConfig {
        private static final String DEFAULT_HOST = "0.0.0.0";
        private static final int DEFAULT_PORT = 8080;
        private static final String DEFAULT_CONTEXT_PATH = "/";
        private static final boolean DEFAULT_HTTPS_ACTIVATION = false;
        private static final boolean DEFAULT_HTTP2_ACTIVATION = false;
        private String host = "0.0.0.0";
        @SingleValue
        @Min(value=0L)
        @Max(value=65535L)
        private int port = 8080;
        private String contextPath = "/";
        private boolean https = false;
        private boolean http2 = false;

        public String getHost() {
            return this.host;
        }

        public ServerConfig setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public ServerConfig setPort(int port) {
            this.port = port;
            return this;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public ServerConfig setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public boolean isHttps() {
            return this.https;
        }

        public ServerConfig setHttps(boolean https) {
            this.https = https;
            return this;
        }

        public boolean isHttp2() {
            return this.http2;
        }

        public ServerConfig setHttp2(boolean http2) {
            this.http2 = http2;
            return this;
        }
    }

    @Config(value="static")
    public static class StaticResourcesConfig {
        private static final int DEFAULT_BUFFER_SIZE = 65535;
        @SingleValue
        private boolean enabled = true;
        private int bufferSize = 65535;
        private boolean minification = true;
        private boolean gzip = true;
        private boolean gzipOnTheFly = true;
        private CacheConfig cache = new CacheConfig();

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public boolean isMinificationEnabled() {
            return this.minification;
        }

        public boolean isGzipEnabled() {
            return this.gzip;
        }

        public boolean isOnTheFlyGzipEnabled() {
            return this.gzipOnTheFly;
        }

        public CacheConfig cacheConfig() {
            return this.cache;
        }

        @Config(value="cache")
        public static class CacheConfig {
            private static final int DEFAULT_CACHE_MAX_SIZE = 8192;
            private static final int DEFAULT_CACHE_CONCURRENCY = 32;
            private int maxSize = 8192;
            private int initialSize = this.maxSize / 4;
            private int concurrencyLevel = 32;

            public int getInitialSize() {
                return this.initialSize;
            }

            public int getMaxSize() {
                return this.maxSize;
            }

            public int getConcurrencyLevel() {
                return this.concurrencyLevel;
            }
        }
    }

    @Config(value="cors")
    public static class CORSConfig {
        @SingleValue
        private boolean enabled;
        private String path = "/*";
        private Map<String, String> properties = new HashMap<String, String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

