/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.sail.Sail;
import org.semanticdesktop.nepomuk.nrl.validator.ModelTester;
import org.semanticdesktop.nepomuk.nrl.validator.StandaloneValidator;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.exception.ModelTesterException;
import org.semanticdesktop.nepomuk.nrl.validator.exception.StandaloneValidatorException;
import org.semanticdesktop.nepomuk.nrl.validator.impl.StandaloneValidatorImpl;
import org.semanticdesktop.nepomuk.nrl.validator.testres.TESTRESOURCES;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.UnionMemoryStore;

public class StandaloneValidatorTests {
    @Test
    public void testExternalSailValidator() throws Exception {
        UnionMemoryStore nativeStore = new UnionMemoryStore();
        InfSail infSail = new InfSail((Sail)nativeStore);
        infSail.initialize();
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl(infSail);
        this.addRemoveOntologyTest(validator);
    }

    @Test
    public void testInternalSailValidator() throws Exception {
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl();
        this.addRemoveOntologyTest(validator);
    }

    @Test
    public void testModelExternalSailValidator() throws Exception {
        UnionMemoryStore nativeStore = new UnionMemoryStore();
        InfSail infSail = new InfSail((Sail)nativeStore);
        infSail.initialize();
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl(infSail);
        this.addRemoveModelTest(validator);
    }

    @Test
    public void testModelInternalSailValidator() throws Exception {
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl();
        this.addRemoveModelTest(validator);
    }

    public void addRemoveOntologyTest(StandaloneValidator validator) throws StandaloneValidatorException {
        List<String> urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)urisList.size(), (Object)0);
        InputStream stream = ClassLoader.getSystemResourceAsStream(TESTRESOURCES.RDF_RDF_FILE);
        Assert.assertNotNull((Object)stream);
        validator.addOntology(stream, RDFFormat.RDFXML.getDefaultMIMEType(), TESTRESOURCES.RDF_GRAPH_URI);
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)1, (Object)urisList.size());
        Assert.assertEquals((Object)TESTRESOURCES.RDF_GRAPH_URI, (Object)urisList.get(0));
        stream = ClassLoader.getSystemResourceAsStream(TESTRESOURCES.OWL_RDF_FILE);
        Assert.assertNotNull((Object)stream);
        validator.addOntology(stream, RDFFormat.RDFXML.getDefaultMIMEType(), TESTRESOURCES.OWL_GRAPH_URI);
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)2, (Object)urisList.size());
        validator.removeOntology(TESTRESOURCES.RDF_GRAPH_URI);
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)1, (Object)urisList.size());
        validator.removeOntology(TESTRESOURCES.OWL_GRAPH_URI);
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)0, (Object)urisList.size());
    }

    public void addRemoveModelTest(StandaloneValidator validator) throws Exception {
        List<String> urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)urisList.size(), (Object)0);
        InputStream stream = ClassLoader.getSystemResourceAsStream(TESTRESOURCES.RDF_RDF_FILE);
        Assert.assertNotNull((Object)stream);
        Model tempModel = RDF2Go.getModelFactory().createModel();
        tempModel.open();
        tempModel.readFrom(stream, Syntax.RdfXml);
        validator.addOntology(tempModel, TESTRESOURCES.RDF_GRAPH_URI);
        tempModel.close();
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)1, (Object)urisList.size());
        Assert.assertEquals((Object)TESTRESOURCES.RDF_GRAPH_URI, (Object)urisList.get(0));
        stream = ClassLoader.getSystemResourceAsStream(TESTRESOURCES.OWL_RDF_FILE);
        Assert.assertNotNull((Object)stream);
        tempModel.open();
        tempModel.removeAll();
        tempModel.readFrom(stream, Syntax.RdfXml);
        validator.addOntology(tempModel, TESTRESOURCES.OWL_GRAPH_URI);
        tempModel.close();
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)2, (Object)urisList.size());
        validator.removeOntology(TESTRESOURCES.RDF_GRAPH_URI);
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)1, (Object)urisList.size());
        validator.removeOntology(TESTRESOURCES.OWL_GRAPH_URI);
        urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)0, (Object)urisList.size());
    }

    @Test
    public void basicSubClassOfInferenceTest() throws Exception {
        ModelTester tester = this.getBasicInferenceModelTester();
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl();
        validator.setModelTesters(tester);
        InputStream stream = ClassLoader.getSystemResourceAsStream(String.valueOf(TESTRESOURCES.RES_PACKAGE_NAME) + "/testontology1.n3");
        Assert.assertNotNull((Object)stream);
        validator.addOntology(stream, RDFFormat.TURTLE.getDefaultMIMEType(), "http://example.org/ontology1");
        List<String> urisList = validator.listOntologyUris();
        Assert.assertEquals((Object)1, (Object)urisList.size());
        Assert.assertEquals((Object)"http://example.org/ontology1", (Object)urisList.get(0));
        stream = ClassLoader.getSystemResourceAsStream(String.valueOf(TESTRESOURCES.RES_PACKAGE_NAME) + "/testinstance1.n3");
        validator.validate(stream, RDFFormat.TURTLE.getDefaultMIMEType());
    }

    private ModelTester getBasicInferenceModelTester() {
        return new ModelTester(){

            public ValidationReport performTests(Model unionModel, Model dataModel) throws ModelTesterException {
                URI instance1 = unionModel.createURI("http://example.org/inst1#Instance1");
                URI instance2 = unionModel.createURI("http://example.org/inst1#Instance2");
                URI class1 = unionModel.createURI("http://example.org/ontology1#Class1");
                URI class2 = unionModel.createURI("http://example.org/ontology1#Class2");
                Assert.assertTrue((boolean)dataModel.contains((ResourceOrVariable)instance1, (UriOrVariable)RDF.type, (NodeOrVariable)class1));
                Assert.assertTrue((boolean)dataModel.contains((ResourceOrVariable)instance2, (UriOrVariable)RDF.type, (NodeOrVariable)class2));
                Assert.assertEquals((Object)2L, (Object)dataModel.size());
                Assert.assertTrue((boolean)unionModel.contains((ResourceOrVariable)class1, (UriOrVariable)RDF.type, (NodeOrVariable)RDFS.Class));
                Assert.assertTrue((boolean)unionModel.contains((ResourceOrVariable)class2, (UriOrVariable)RDF.type, (NodeOrVariable)RDFS.Class));
                Assert.assertTrue((boolean)unionModel.contains((ResourceOrVariable)class2, (UriOrVariable)RDFS.subClassOf, (NodeOrVariable)class1));
                Assert.assertTrue((boolean)unionModel.contains((ResourceOrVariable)instance1, (UriOrVariable)RDF.type, (NodeOrVariable)class1));
                Assert.assertTrue((boolean)unionModel.contains((ResourceOrVariable)instance2, (UriOrVariable)RDF.type, (NodeOrVariable)class2));
                Assert.assertTrue((boolean)unionModel.contains((ResourceOrVariable)instance2, (UriOrVariable)RDF.type, (NodeOrVariable)class1));
                return null;
            }

            public void performTests(Model unionModel, Model dataModel, ValidationReport report) throws ModelTesterException {
            }
        };
    }

    private void printSail(Sail sail) {
        RepositoryConnection connection = null;
        SailRepository repository = new SailRepository(sail);
        try {
            try {
                connection = repository.getConnection();
                RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)RDFFormat.TRIG);
                RDFWriter writer = rdfWriterFactory.getWriter((OutputStream)System.out);
                connection.export((RDFHandler)writer, new Resource[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void closeConnection(RepositoryConnection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

