/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.ontoware.rdf2go.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationMessage;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.impl.StandaloneValidatorImpl;
import org.semanticdesktop.nepomuk.nrl.validator.testers.NRLClosedWorldModelTester;
import org.semanticdesktop.nepomuk.nrl.validator.testres.TESTRESOURCES;

public class ValidatorTest {
    public void doTest(String ontology, String ontologyUri, String instance, int errors) throws Exception {
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl();
        InputStream stream = ClassLoader.getSystemResourceAsStream(String.valueOf(TESTRESOURCES.RES_PACKAGE_NAME) + "/" + ontology);
        Assert.assertNotNull((Object)stream);
        validator.addOntology(stream, RDFFormat.TURTLE.getDefaultMIMEType(), ontologyUri);
        stream = ClassLoader.getSystemResourceAsStream(String.valueOf(TESTRESOURCES.RES_PACKAGE_NAME) + "/" + instance);
        NRLClosedWorldModelTester tester = new NRLClosedWorldModelTester();
        validator.setModelTesters(tester);
        ValidationReport report = validator.validate(stream, RDFFormat.TURTLE.getDefaultMIMEType());
        this.printValidationReport(report);
        Assert.assertEquals((Object)errors, (Object)report.getMessages().size());
    }

    public void printValidationReport(ValidationReport report) {
        System.out.println("Validation report");
        List<ValidationMessage> messages = report.getMessages();
        int i = 1;
        for (ValidationMessage msg : messages) {
            System.out.print(i + ": ");
            System.out.print(String.valueOf(msg.getMessageType().toString()) + " ");
            System.out.print(String.valueOf(msg.getMessageTitle()) + " ");
            System.out.print(String.valueOf(msg.getMessage()) + " ");
            for (Statement stmt : msg.getStatements()) {
                System.out.print("{" + stmt.getSubject().toString() + "," + stmt.getPredicate().toString() + "," + stmt.getObject().toString() + "}");
            }
            System.out.println();
            ++i;
        }
    }
}

