/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.webdriver;

import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.sikuli.api.DefaultScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.Screen;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.webdriver.DefaultImageElement;
import org.sikuli.webdriver.ImageElement;
import org.sikuli.webdriver.WebDriverScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SikuliFirefoxDriver
extends FirefoxDriver {
    static Logger logger = LoggerFactory.getLogger(SikuliFirefoxDriver.class);
    private static final int DEFAULT_WAIT_TIMEOUT_MSECS = 10000;
    ScreenRegion webdriverRegion;

    public SikuliFirefoxDriver() {
        WebDriverScreen webDriverScreen;
        try {
            webDriverScreen = new WebDriverScreen((TakesScreenshot)this);
        }
        catch (IOException e1) {
            throw new RuntimeException("unable to initialize SikuliFirefoxDriver");
        }
        this.webdriverRegion = new DefaultScreenRegion((Screen)webDriverScreen);
    }

    public WebElement findElementByLocation(int x, int y) {
        return (WebElement)this.executeScript("return document.elementFromPoint(" + x + "," + y + ")", new Object[0]);
    }

    public ImageElement findImageElement(URL imageUrl) {
        ImageTarget target = new ImageTarget(imageUrl);
        ScreenRegion imageRegion = this.webdriverRegion.wait((Target)target, 10000);
        if (imageRegion == null) {
            logger.debug("image is not found");
            return null;
        }
        Rectangle r = imageRegion.getBounds();
        logger.debug("image is found at {} {} {} {}", new Object[]{r.x, r.y, r.width, r.height});
        ScreenLocation center = imageRegion.getCenter();
        WebElement foundWebElement = this.findElementByLocation(center.getX(), center.getY());
        Rectangle r2 = imageRegion.getBounds();
        return new DefaultImageElement((WebDriver)this, foundWebElement, r2.x, r2.y, r2.width, r2.height);
    }
}

