/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.webdriver;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.sikuli.api.Screen;

class WebDriverScreen
implements Screen {
    private final TakesScreenshot driver;
    private final Dimension size;

    public WebDriverScreen(TakesScreenshot driver) throws IOException {
        this.driver = driver;
        File screenshotFile = (File)driver.getScreenshotAs(OutputType.FILE);
        BufferedImage b = ImageIO.read(screenshotFile);
        this.size = new Dimension(b.getWidth(), b.getHeight());
    }

    BufferedImage crop(BufferedImage src, int x, int y, int width, int height) {
        BufferedImage dest = new BufferedImage(width, height, 5);
        Graphics g = dest.getGraphics();
        g.drawImage(src, 0, 0, width, height, x, y, x + width, y + height, null);
        g.dispose();
        return dest;
    }

    public BufferedImage getScreenshot(int x, int y, int width, int height) {
        File screenshotFile = (File)this.driver.getScreenshotAs(OutputType.FILE);
        try {
            BufferedImage full = ImageIO.read(screenshotFile);
            BufferedImage cropped = this.crop(full, x, y, width, height);
            return cropped;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Dimension getSize() {
        return this.size;
    }
}

