/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.webdriver.support;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.sikuli.webdriver.ImageElement;
import org.sikuli.webdriver.support.ImageElementLocator;
import org.sikuli.webdriver.support.ImageElementLocatorFactory;
import org.sikuli.webdriver.support.LocatingImageElementHandler;
import org.sikuli.webdriver.support.LocatingImageElementListHandler;

class ImageElementFieldDecorator
extends DefaultFieldDecorator
implements FieldDecorator {
    private final ImageElementLocatorFactory factory;

    public ImageElementFieldDecorator(ImageElementLocatorFactory factoryRef) {
        super((ElementLocatorFactory)factoryRef);
        this.factory = factoryRef;
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return super.decorate(loader, field);
        }
        return this.decorateAsImageElement(loader, field);
    }

    private Object decorateAsImageElement(ClassLoader loader, Field field) {
        if (!ImageElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ImageElementLocator locator = this.factory.createImageElementLocator(field);
        if (locator == null) {
            return null;
        }
        if (ImageElement.class.isAssignableFrom(field.getType())) {
            return this.proxyForImageElementLocator(loader, locator);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return this.proxyForImageElementListLocator(loader, locator);
        }
        return null;
    }

    private boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        if (!ImageElement.class.equals((Object)listType)) {
            return false;
        }
        return field.getAnnotation(FindBy.class) != null;
    }

    protected ImageElement proxyForImageElementLocator(ClassLoader loader, ImageElementLocator locator) {
        LocatingImageElementHandler handler = new LocatingImageElementHandler(locator);
        ImageElement proxy = (ImageElement)Proxy.newProxyInstance(loader, new Class[]{ImageElement.class}, (InvocationHandler)handler);
        return proxy;
    }

    protected List<ImageElement> proxyForImageElementListLocator(ClassLoader loader, ImageElementLocator locator) {
        LocatingImageElementListHandler handler = new LocatingImageElementListHandler(locator);
        List proxy = (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
        return proxy;
    }
}

