/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.load.CompositeArray;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.InstantiationException;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.PrimitiveArray;
import org.simpleframework.xml.load.Signature;
import org.simpleframework.xml.load.Source;

class ElementArrayLabel
implements Label {
    private ElementArray label;
    private Signature detail;
    private Class type;
    private String parent;
    private String name;

    public ElementArrayLabel(Contact contact, ElementArray label) {
        this.detail = new Signature(contact, this);
        this.type = contact.getType();
        this.parent = label.parent();
        this.name = label.name();
        this.label = label;
    }

    public Converter getConverter(Source root) throws Exception {
        String parent = this.getParent();
        if (!this.type.isArray()) {
            throw new InstantiationException("Type is not an array %s for %s", this.type, this.label);
        }
        return this.getConverter(root, parent);
    }

    private Converter getConverter(Source root, String parent) throws Exception {
        Class<?> entry = this.type.getComponentType();
        if (!root.isPrimitive(entry)) {
            return new CompositeArray(root, this.type, entry, parent);
        }
        return new PrimitiveArray(root, this.type, entry, parent);
    }

    public String getParent() throws Exception {
        if (this.detail.isEmpty(this.parent)) {
            this.parent = this.detail.getParent();
        }
        return this.parent;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public Class getDependant() {
        return this.type.getComponentType();
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return this.label.data();
    }

    public String getEmpty() {
        return null;
    }

    public boolean isInline() {
        return false;
    }

    public String toString() {
        return this.detail.toString();
    }
}

