/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.simpleframework.xml.transform.DateFactory;
import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateTransform<T extends Date>
implements Transform<T> {
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss.S z";
    private final DateFactory<T> factory;
    private final DateFormat format;

    public DateTransform(Class<T> type) throws Exception {
        this(type, FORMAT);
    }

    public DateTransform(Class<T> type, String format) throws Exception {
        this.format = new SimpleDateFormat(format);
        this.factory = new DateFactory<T>(type);
    }

    @Override
    public synchronized T read(String text) throws Exception {
        Date date = this.format.parse(text);
        Long time = date.getTime();
        return this.factory.getInstance(time);
    }

    @Override
    public synchronized String write(T date) throws Exception {
        return this.format.format((Date)date);
    }
}

