/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;
import org.simpleframework.xml.stream.Style;

class CompositeKey
implements Converter {
    private final Traverser root;
    private final Style style;
    private final Entry entry;
    private final Class type;

    public CompositeKey(Source root, Entry entry, Class type) throws Exception {
        this.root = new Traverser(root);
        this.style = root.getStyle();
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getKey();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute at %s", this.type, line);
        }
        return this.read(node, name);
    }

    private Object read(InputNode node, String key) throws Exception {
        String name = this.style.getElement(key);
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            return null;
        }
        if (node.isEmpty()) {
            return null;
        }
        return this.root.read(node, this.type);
    }

    public boolean validate(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getKey();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute at %s", this.type, line);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String key) throws Exception {
        String name = this.style.getElement(key);
        InputNode next = node.getNext(name);
        if (next == null) {
            return true;
        }
        if (next.isEmpty()) {
            return true;
        }
        return this.root.validate(next, this.type);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String key = this.entry.getKey();
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute", this.type);
        }
        if (key == null) {
            key = Factory.getName(this.type);
        }
        String name = this.style.getElement(key);
        this.root.write(node, item, this.type, name);
    }
}

