/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.PrimitiveFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class Primitive
implements Converter {
    private final PrimitiveFactory factory;
    private final Source root;
    private final String empty;
    private final Class field;

    public Primitive(Source root, Class type) {
        this(root, type, null);
    }

    public Primitive(Source root, Class type, String empty) {
        this.factory = new PrimitiveFactory(root, type);
        this.empty = empty;
        this.field = type;
        this.root = root;
    }

    public Object read(InputNode node) throws Exception {
        if (node.isElement()) {
            return this.readElement(node);
        }
        return this.read(node, this.field);
    }

    public Object read(InputNode node, Class type) throws Exception {
        String value = node.getValue();
        if (value == null) {
            return null;
        }
        if (this.empty != null && value.equals(this.empty)) {
            return this.empty;
        }
        return this.readTemplate(value, type);
    }

    private Object readElement(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            return this.readElement(node, type);
        }
        return type.getInstance();
    }

    private Object readElement(InputNode node, Type type) throws Exception {
        Object value = this.read(node, this.field);
        if (value != null) {
            return type.getInstance(value);
        }
        return value;
    }

    private Object readTemplate(String value, Class type) throws Exception {
        String text = this.root.getProperty(value);
        if (text != null) {
            return this.factory.getInstance(text, type);
        }
        return null;
    }

    public boolean validate(InputNode node) throws Exception {
        if (node.isElement()) {
            this.validateElement(node);
        } else {
            node.getValue();
        }
        return true;
    }

    private boolean validateElement(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            type.getInstance(type);
        }
        return true;
    }

    public void write(OutputNode node, Object source) throws Exception {
        String text = this.factory.getText(source);
        if (text != null) {
            node.setValue(text);
        }
    }
}

