/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Composite;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.RootException;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class Traverser {
    private final Source root;
    private final Style style;

    public Traverser(Source root) {
        this.style = root.getStyle();
        this.root = root;
    }

    public Object read(InputNode node, Class type) throws Exception {
        Composite factory = this.getComposite(type);
        Object value = factory.read(node);
        Class<?> real = value.getClass();
        return this.read(node, real, value);
    }

    public Object read(InputNode node, Object value) throws Exception {
        Class<?> type = value.getClass();
        Composite factory = this.getComposite(type);
        Object real = factory.read(node, value);
        return this.read(node, type, real);
    }

    private Object read(InputNode node, Class type, Object value) throws Exception {
        String root = this.getName(type);
        if (root == null) {
            throw new RootException("Root annotation required for %s", type);
        }
        return value;
    }

    public boolean validate(InputNode node, Class type) throws Exception {
        Composite factory = this.getComposite(type);
        String root = this.getName(type);
        if (root == null) {
            throw new RootException("Root annotation required for %s", type);
        }
        return factory.validate(node);
    }

    public void write(OutputNode node, Object source) throws Exception {
        this.write(node, source, source.getClass());
    }

    public void write(OutputNode node, Object source, Class expect) throws Exception {
        Class<?> type = source.getClass();
        String root = this.getName(type);
        if (root == null) {
            throw new RootException("Root annotation required for %s", type);
        }
        this.write(node, source, expect, root);
    }

    public void write(OutputNode node, Object source, Class expect, String name) throws Exception {
        OutputNode child = node.getChild(name);
        if (source != null) {
            Class<?> type = source.getClass();
            if (!this.root.setOverride(expect, source, child)) {
                this.getComposite(type).write(child, source);
            }
        }
        child.commit();
    }

    private Composite getComposite(Class type) {
        return new Composite(this.root, type);
    }

    protected String getName(Class type) throws Exception {
        String root = Factory.getName(type);
        String name = this.style.getElement(root);
        return name;
    }
}

