/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.DefaultMatcher;
import org.simpleframework.xml.transform.EmptyMatcher;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.transform.TransformCache;
import org.simpleframework.xml.transform.TransformException;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.WeakCache;

public class Transformer {
    private TransformCache cache;
    private Matcher matcher;
    private Cache error;

    public Transformer() {
        this(new EmptyMatcher());
    }

    private Transformer(Matcher matcher) {
        this.matcher = new DefaultMatcher(matcher);
        this.cache = new TransformCache();
        this.error = new WeakCache();
    }

    public Object read(String value, Class type) throws Exception {
        Transform transform = this.lookup(type);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", type);
        }
        return transform.read(value);
    }

    public String write(Object value, Class type) throws Exception {
        Transform transform = this.lookup(type);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", type);
        }
        return transform.write(value);
    }

    public boolean valid(Class type) throws Exception {
        return this.lookup(type) != null;
    }

    private Transform lookup(Class type) throws Exception {
        Transform transform = (Transform)this.cache.fetch(type);
        if (transform != null) {
            return transform;
        }
        if (this.error.contains(type)) {
            return null;
        }
        return this.match(type);
    }

    private Transform match(Class type) throws Exception {
        Transform transform = this.matcher.match(type);
        if (transform != null) {
            this.cache.cache(type, transform);
        } else {
            this.error.cache(type, this);
        }
        return transform;
    }
}

