/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.List;
import org.simpleframework.xml.core.Builder;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassCreator
implements Creator {
    private final List<Builder> list;
    private final ParameterMap map;
    private final Builder primary;

    public ClassCreator(List<Builder> list, ParameterMap map, Builder primary) {
        this.primary = primary;
        this.list = list;
        this.map = map;
    }

    @Override
    public boolean isDefault() {
        return this.primary != null;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.primary.getInstance();
    }

    @Override
    public Object getInstance(Criteria criteria) throws Exception {
        Builder builder = this.getBuilder(criteria);
        if (builder == null) {
            throw new PersistenceException("Could not find a constructor", new Object[0]);
        }
        return builder.getInstance(criteria);
    }

    private Builder getBuilder(Criteria criteria) throws Exception {
        Builder result = this.primary;
        int max = 0;
        for (Builder builder : this.list) {
            int score = builder.score(criteria);
            if (score <= max) continue;
            result = builder;
            max = score;
        }
        return result;
    }

    @Override
    public Parameter getParameter(String name) {
        return (Parameter)this.map.get(name);
    }

    @Override
    public List<Builder> getBuilders() {
        return this.list;
    }
}

