/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import org.simpleframework.xml.core.ClassMap;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.Variable;

class Builder {
    private final Constructor factory;
    private final Parameter[] list;
    private final ClassMap map;

    public Builder(Constructor factory, ClassMap map) {
        this.list = map.list();
        this.factory = factory;
        this.map = map;
    }

    public boolean isDefault() {
        return this.map.size() == 0;
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.map.get(name);
    }

    public Object getInstance() throws Exception {
        return this.factory.newInstance(new Object[0]);
    }

    public Object getInstance(Criteria criteria) throws Exception {
        Object[] values = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Object value;
            String name = this.list[i].getName();
            Variable variable = criteria.remove(name);
            values[i] = value = variable.getValue();
        }
        return this.factory.newInstance(values);
    }

    public int score(Criteria criteria) throws Exception {
        int score = 0;
        for (int i = 0; i < this.list.length; ++i) {
            String name = this.list[i].getName();
            Variable label = criteria.get(name);
            if (label == null) {
                return -1;
            }
            ++score;
        }
        return score;
    }

    public String toString() {
        return this.factory.toString();
    }
}

