/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.List;
import org.simpleframework.xml.core.Builder;
import org.simpleframework.xml.core.ClassMap;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassCreator
implements Creator {
    private final List<Builder> list;
    private final Builder primary;
    private final ClassMap map;
    private final Class type;

    public ClassCreator(List<Builder> list, ClassMap map, Builder primary) {
        this.type = map.getType();
        this.primary = primary;
        this.list = list;
        this.map = map;
    }

    @Override
    public boolean isDefault() {
        return this.primary != null;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.primary.getInstance();
    }

    @Override
    public Object getInstance(Criteria criteria) throws Exception {
        Builder builder = this.getBuilder(criteria);
        if (builder == null) {
            throw new PersistenceException("Constructor not matched for %s", this.type);
        }
        return builder.getInstance(criteria);
    }

    private Builder getBuilder(Criteria criteria) throws Exception {
        Builder result = this.primary;
        int max = 0;
        for (Builder builder : this.list) {
            int score = builder.score(criteria);
            if (score <= max) continue;
            result = builder;
            max = score;
        }
        return result;
    }

    @Override
    public Parameter getParameter(String name) {
        return (Parameter)this.map.get(name);
    }

    @Override
    public List<Builder> getBuilders() {
        return this.list;
    }
}

