/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ConversionInstance;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;

class CollectionFactory
extends Factory {
    public CollectionFactory(Context context, Class field) {
        super(context, field);
    }

    public Object getInstance() throws Exception {
        Class type = this.field;
        if (!CollectionFactory.isInstantiable(type)) {
            type = this.getConversion(this.field);
        }
        if (!this.isCollection(type)) {
            throw new InstantiationException("Type is not a collection %s", this.field);
        }
        return type.newInstance();
    }

    public Instance getInstance(InputNode node) throws Exception {
        Value value = this.getOverride(node);
        if (value != null) {
            return this.getInstance(value);
        }
        if (!CollectionFactory.isInstantiable(this.field)) {
            this.field = this.getConversion(this.field);
        }
        if (!this.isCollection(this.field)) {
            throw new InstantiationException("Type is not a collection %s", this.field);
        }
        return this.context.getInstance(this.field);
    }

    public Instance getInstance(Value value) throws Exception {
        Class type = value.getType();
        if (!CollectionFactory.isInstantiable(type)) {
            type = this.getConversion(type);
        }
        if (!this.isCollection(type)) {
            throw new InstantiationException("Type is not a collection %s", type);
        }
        return new ConversionInstance(this.context, value, type);
    }

    public Class getConversion(Class type) throws Exception {
        if (type.isAssignableFrom(ArrayList.class)) {
            return ArrayList.class;
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return HashSet.class;
        }
        if (type.isAssignableFrom(TreeSet.class)) {
            return TreeSet.class;
        }
        throw new InstantiationException("Cannot instantiate %s", type);
    }

    private boolean isCollection(Class type) {
        return Collection.class.isAssignableFrom(type);
    }
}

