/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.strategy;

import java.lang.reflect.Array;
import java.util.Map;
import org.simpleframework.xml.strategy.ArrayValue;
import org.simpleframework.xml.strategy.ObjectValue;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.NodeMap;

public class TreeStrategy
implements Strategy {
    private static final String LENGTH = "length";
    private static final String LABEL = "class";
    private String length;
    private String label;

    public TreeStrategy() {
        this(LABEL, LENGTH);
    }

    public TreeStrategy(String label, String length) {
        this.length = length;
        this.label = label;
    }

    public Value getRoot(Class field, NodeMap node, Map map) throws Exception {
        return this.getElement(field, node, map);
    }

    public Value getElement(Class field, NodeMap node, Map map) throws Exception {
        Class type = this.getValue(field, node);
        if (field.isArray()) {
            return this.getArray(type, node);
        }
        if (field != type) {
            return new ObjectValue(type);
        }
        return null;
    }

    private Value getArray(Class type, NodeMap node) throws Exception {
        Object entry = node.remove(this.length);
        int size = 0;
        if (entry != null) {
            String value = entry.getValue();
            size = Integer.parseInt(value);
        }
        return new ArrayValue(type, size);
    }

    private Class getValue(Class field, NodeMap node) throws Exception {
        Object entry = node.remove(this.label);
        Class type = field;
        if (field.isArray()) {
            type = field.getComponentType();
        }
        if (entry != null) {
            String name = entry.getValue();
            type = this.getClass(name);
        }
        return type;
    }

    public boolean setRoot(Class field, Object value, NodeMap node, Map map) {
        return this.setElement(field, value, node, map);
    }

    public boolean setElement(Class field, Object value, NodeMap node, Map map) {
        Class type;
        Class real = type = value.getClass();
        if (type.isArray()) {
            real = this.setArray(field, value, node);
        }
        if (type != field) {
            node.put(this.label, real.getName());
        }
        return false;
    }

    private Class setArray(Class field, Object value, NodeMap node) {
        int size = Array.getLength(value);
        if (this.length != null) {
            node.put(this.length, String.valueOf(size));
        }
        return field.getComponentType();
    }

    private Class getClass(String type) throws Exception {
        ClassLoader loader = TreeStrategy.getClassLoader();
        if (loader == null) {
            loader = this.getCallerClassLoader();
        }
        return loader.loadClass(type);
    }

    private ClassLoader getCallerClassLoader() throws Exception {
        return this.getClass().getClassLoader();
    }

    private static ClassLoader getClassLoader() throws Exception {
        return Thread.currentThread().getContextClassLoader();
    }
}

