/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.ClassType;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.PathParser;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.LimitedCache;

class ExpressionBuilder {
    private final Cache<Expression> cache = new LimitedCache<Expression>();
    private final Format format;
    private final Type type;

    public ExpressionBuilder(Class type, Format format) {
        this(new ClassType(type), format);
    }

    public ExpressionBuilder(Type type, Format format) {
        this.format = format;
        this.type = type;
    }

    public Expression build(String path) throws Exception {
        Expression expression = this.cache.fetch(path);
        if (expression == null) {
            return this.create(path);
        }
        return expression;
    }

    private Expression create(String path) throws Exception {
        PathParser expression = new PathParser(path, this.type, this.format);
        if (this.cache != null) {
            this.cache.cache(path, expression);
        }
        return expression;
    }
}

