/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.commons.lang.StringUtils;
import org.skyscreamer.nevado.jms.NevadoConnection;
import org.skyscreamer.nevado.jms.NevadoQueueConnection;
import org.skyscreamer.nevado.jms.NevadoTopicConnection;
import org.skyscreamer.nevado.jms.connector.SQSConnectorFactory;
import org.skyscreamer.nevado.jms.resource.NevadoReferencableFactory;

public class NevadoConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Serializable,
Referenceable {
    public static final String JNDI_AWS_ACCESS_KEY = "awsAccessKey";
    public static final String JNDI_AWS_SECRET_KEY = "awsSecretKey";
    public static final String JNDI_CLIENT_ID = "clientID";
    public static final String JNDI_JMS_DELIVERY_MODE = "jmsDeliveryMode";
    public static final String JNDI_JMS_TTL = "jmsTTL";
    public static final String JNDI_JMS_PRIORITY = "jmsPriority";
    public static final String JNDI_SNS_ENDPOINT = "awsSNSEndpoint";
    public static final String JNDI_SQS_ENDPOINT = "awsSQSEndpoint";
    public static final String JNDI_SQS_CONNECTOR_FACTORY_CLASS = "sqsConnectorFactoryClass";
    public static final String JNDI_MAX_POLL_WAIT_MS = "maxPollWaitMs";
    public static final String JNDI_DURABLE_SUBSCRIBER_PREFIX_OVERRIDE = "durableSubscriberPrefixOverride";
    private SQSConnectorFactory _sqsConnectorFactory;
    private volatile String _awsAccessKey;
    private volatile String _awsSecretKey;
    private volatile String _awsSQSEndpoint = null;
    private volatile String _awsSNSEndpoint = null;
    private volatile String _clientID;
    private volatile Integer _jmsDeliveryMode;
    private volatile Long _jmsTTL;
    private volatile Integer _jmsPriority;
    private String _temporaryQueueSuffix = "";
    private String _temporaryTopicSuffix = "";
    private long _maxPollWaitMs = 5000L;
    private volatile String _durableSubscriberPrefixOverride = null;

    public NevadoConnectionFactory() {
    }

    public NevadoConnectionFactory(SQSConnectorFactory sqsConnectorFactory) {
        this._sqsConnectorFactory = sqsConnectorFactory;
    }

    public NevadoQueueConnection createQueueConnection() throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoQueueConnection connection = new NevadoQueueConnection(this._sqsConnectorFactory.getInstance(this._awsAccessKey, this._awsSecretKey, this._awsSQSEndpoint, this._awsSNSEndpoint));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoQueueConnection createQueueConnection(String awsAccessKey, String awsSecretKey) throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoQueueConnection connection = new NevadoQueueConnection(this._sqsConnectorFactory.getInstance(awsAccessKey, awsSecretKey, this._awsSQSEndpoint, this._awsSNSEndpoint));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoConnection createConnection() throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoConnection connection = new NevadoConnection(this._sqsConnectorFactory.getInstance(this._awsAccessKey, this._awsSecretKey, this._awsSQSEndpoint, this._awsSNSEndpoint));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoConnection createConnection(String awsAccessKey, String awsSecretKey) throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoConnection connection = new NevadoConnection(this._sqsConnectorFactory.getInstance(awsAccessKey, awsSecretKey, this._awsSQSEndpoint, this._awsSNSEndpoint));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoTopicConnection createTopicConnection() throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoTopicConnection connection = new NevadoTopicConnection(this._sqsConnectorFactory.getInstance(this._awsAccessKey, this._awsSecretKey, this._awsSQSEndpoint, this._awsSNSEndpoint));
        this.initializeConnection(connection);
        return connection;
    }

    public TopicConnection createTopicConnection(String awsAccessKey, String awsSecretKey) throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoTopicConnection connection = new NevadoTopicConnection(this._sqsConnectorFactory.getInstance(awsAccessKey, awsSecretKey, this._awsSQSEndpoint, this._awsSNSEndpoint));
        this.initializeConnection(connection);
        return connection;
    }

    private void initializeConnection(NevadoConnection connection) throws JMSException {
        if (StringUtils.isNotEmpty((String)this._clientID)) {
            connection.setClientID(this._clientID);
        }
        connection.setOverrideJMSDeliveryMode(this._jmsDeliveryMode);
        connection.setOverrideJMSPriority(this._jmsPriority);
        connection.setOverrideJMSTTL(this._jmsTTL);
        connection.setTemporaryQueueSuffix(this._temporaryQueueSuffix);
        connection.setTemporaryTopicSuffix(this._temporaryTopicSuffix);
        connection.setMaxPollWaitMs(this._maxPollWaitMs);
        connection.setDurableSubcriptionPrefixOveride(this._durableSubscriberPrefixOverride);
    }

    public void setSqsConnectorFactory(SQSConnectorFactory sqsConnectorFactory) {
        this._sqsConnectorFactory = sqsConnectorFactory;
    }

    public SQSConnectorFactory getSqsConnectorFactory() {
        return this._sqsConnectorFactory;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this._awsAccessKey = awsAccessKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this._awsSecretKey = awsSecretKey;
    }

    public void setAwsSQSEndpoint(String awsSQSEndpoint) {
        this._awsSQSEndpoint = awsSQSEndpoint;
    }

    public void setAwsSNSEndpoint(String awsSNSEndpoint) {
        this._awsSNSEndpoint = awsSNSEndpoint;
    }

    public void setClientID(String clientID) {
        this._clientID = clientID;
    }

    public void setOverrideJMSDeliveryMode(Integer jmsDeliveryMode) {
        this._jmsDeliveryMode = jmsDeliveryMode;
    }

    public void setOverrideJMSTTL(Long jmsTTL) {
        this._jmsTTL = jmsTTL;
    }

    public void setOverrideJMSPriority(Integer jmsPriority) {
        this._jmsPriority = jmsPriority;
    }

    public String getAwsAccessKey() {
        return this._awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this._awsSecretKey;
    }

    public String getClientID() {
        return this._clientID;
    }

    public Integer getJMSDeliveryMode() {
        return this._jmsDeliveryMode;
    }

    public Long getJMSTTL() {
        return this._jmsTTL;
    }

    public Integer getJMSPriority() {
        return this._jmsPriority;
    }

    public void setTemporaryQueueSuffix(String temporaryQueueSuffix) {
        this._temporaryQueueSuffix = temporaryQueueSuffix;
    }

    public void setTemporaryTopicSuffix(String temporaryTopicSuffix) {
        this._temporaryTopicSuffix = temporaryTopicSuffix;
    }

    public void setMaxPollWaitMs(long maxPollWaitMs) {
        this._maxPollWaitMs = maxPollWaitMs;
    }

    public void setDurableSubscriberPrefixOverride(String durableSubscriberPrefixOverride) {
        this._durableSubscriberPrefixOverride = durableSubscriberPrefixOverride;
    }

    public String getAwsSQSEndpoint() {
        return this._awsSQSEndpoint;
    }

    public String getAwsSNSEndpoint() {
        return this._awsSNSEndpoint;
    }

    public long getMaxPollWaitMs() {
        return this._maxPollWaitMs;
    }

    public String getDurableSubscriberPrefixOverride() {
        return this._durableSubscriberPrefixOverride;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(NevadoConnectionFactory.class.getName(), new StringRefAddr(JNDI_AWS_ACCESS_KEY, this._awsAccessKey), NevadoReferencableFactory.class.getName(), null);
        reference.add(new StringRefAddr(JNDI_AWS_SECRET_KEY, this._awsSecretKey));
        if (this._clientID != null) {
            reference.add(new StringRefAddr(JNDI_CLIENT_ID, this._clientID));
        }
        if (this._jmsDeliveryMode != null) {
            reference.add(new StringRefAddr(JNDI_JMS_DELIVERY_MODE, this._jmsDeliveryMode.toString()));
        }
        if (this._jmsTTL != null) {
            reference.add(new StringRefAddr(JNDI_JMS_TTL, this._jmsTTL.toString()));
        }
        if (this._jmsPriority != null) {
            reference.add(new StringRefAddr(JNDI_JMS_PRIORITY, this._jmsPriority.toString()));
        }
        if (this._awsSNSEndpoint != null) {
            reference.add(new StringRefAddr(JNDI_SNS_ENDPOINT, this._awsSNSEndpoint.toString()));
        }
        if (this._awsSQSEndpoint != null) {
            reference.add(new StringRefAddr(JNDI_SQS_ENDPOINT, this._awsSQSEndpoint.toString()));
        }
        reference.add(new StringRefAddr(JNDI_MAX_POLL_WAIT_MS, String.valueOf(this._maxPollWaitMs)));
        if (this._durableSubscriberPrefixOverride != null) {
            reference.add(new StringRefAddr(JNDI_DURABLE_SUBSCRIBER_PREFIX_OVERRIDE, this._durableSubscriberPrefixOverride.toString()));
        }
        String sqsConnectorFactoryClass = null;
        if (this._sqsConnectorFactory != null) {
            sqsConnectorFactoryClass = this._sqsConnectorFactory.getClass().getName();
        }
        reference.add(new StringRefAddr(JNDI_SQS_CONNECTOR_FACTORY_CLASS, sqsConnectorFactoryClass));
        return reference;
    }

    private void checkSQSConnectorFactory() throws IllegalStateException {
        if (this._sqsConnectorFactory == null) {
            throw new IllegalStateException("SQSConnectorFactory is null, it must be set.");
        }
    }
}

