/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.apache.commons.lang.StringUtils;
import org.skyscreamer.nevado.jms.message.JMSXProperty;

public class NevadoConnectionMetaData
implements ConnectionMetaData {
    private static Pattern STD_VERSION_PATT = Pattern.compile("^([^\\d]*?)(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?(.*)$");
    private static final NevadoConnectionMetaData INSTANCE = new NevadoConnectionMetaData();
    private final Package _package = this.getClass().getPackage();
    private final String _provider = this._package.getImplementationTitle();
    private final ProviderVersion _version = new ProviderVersion(this._package.getImplementationVersion());

    public static NevadoConnectionMetaData getInstance() {
        return INSTANCE;
    }

    public String getJMSVersion() throws JMSException {
        return "1.1";
    }

    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    public String getJMSProviderName() throws JMSException {
        return this._provider;
    }

    public String getProviderVersion() throws JMSException {
        return this._version.getVersion();
    }

    public int getProviderMajorVersion() throws JMSException {
        return this._version.getMajorVersion();
    }

    public int getProviderMinorVersion() throws JMSException {
        return this._version.getMinorVersion();
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        List<JMSXProperty> propertyList = JMSXProperty.getSupportedProperties();
        Vector<String> propertyNames = new Vector<String>(propertyList.size());
        for (JMSXProperty property : propertyList) {
            propertyNames.add(property.name());
        }
        return propertyNames.elements();
    }

    private class ProviderVersion {
        private String _version;
        private int _majorVersion;
        private int _minorVersion;

        private ProviderVersion(String version) {
            this._version = version;
            if (this._version != null && this._version.indexOf(".") > 0) {
                Matcher m = STD_VERSION_PATT.matcher(version);
                if (!m.find()) {
                    return;
                }
                if (StringUtils.isNotEmpty((String)m.group(2))) {
                    this._majorVersion = Integer.valueOf(m.group(2));
                }
                if (StringUtils.isNotEmpty((String)m.group(3))) {
                    this._minorVersion = Integer.valueOf(m.group(3));
                }
            }
        }

        public String getVersion() {
            return this._version;
        }

        public int getMajorVersion() {
            return this._majorVersion;
        }

        public int getMinorVersion() {
            return this._minorVersion;
        }
    }
}

