/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.amazonaws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.connector.amazonaws.AmazonAwsSQSConnector;
import org.skyscreamer.nevado.jms.connector.amazonaws.AmazonAwsSQSMessage;

public class AmazonAwsSQSQueue
implements SQSQueue {
    public static final String ATTRIBUTE_QUEUE_ARN = "QueueArn";
    public static final String ATTRIBUTE_POLICY = "Policy";
    private final String _queueUrl;
    private final AmazonAwsSQSConnector _amazonAwsSQSConnector;
    private final boolean _isAsync;

    public AmazonAwsSQSQueue(AmazonAwsSQSConnector amazonAwsSQSConnector, String queueUrl) {
        this(amazonAwsSQSConnector, queueUrl, false);
    }

    public AmazonAwsSQSQueue(AmazonAwsSQSConnector amazonAwsSQSConnector, String queueUrl, boolean isAsync) {
        this._amazonAwsSQSConnector = amazonAwsSQSConnector;
        this._queueUrl = queueUrl;
        this._isAsync = isAsync;
    }

    @Override
    public String sendMessage(String serializedMessage) throws JMSException {
        String messageId;
        SendMessageRequest request = new SendMessageRequest(this._queueUrl, serializedMessage);
        try {
            if (this._isAsync) {
                ((AmazonSQSAsync)this._amazonAwsSQSConnector.getAmazonSQS()).sendMessageAsync(request);
                messageId = null;
            } else {
                messageId = this._amazonAwsSQSConnector.getAmazonSQS().sendMessage(request).getMessageId();
            }
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to send message to queue " + this._queueUrl, e);
        }
        return messageId;
    }

    @Override
    public void setMessageVisibilityTimeout(String sqsReceiptHandle, int timeout) throws JMSException {
        try {
            this._amazonAwsSQSConnector.getAmazonSQS().changeMessageVisibility(new ChangeMessageVisibilityRequest(this._queueUrl, sqsReceiptHandle, Integer.valueOf(timeout)));
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to reset message visibility for message with receipt handle " + sqsReceiptHandle, e);
        }
    }

    @Override
    public String getQueueARN() throws JMSException {
        Map queueAttributes;
        GetQueueAttributesRequest request = new GetQueueAttributesRequest(this._queueUrl).withAttributeNames(new String[]{ATTRIBUTE_QUEUE_ARN});
        try {
            queueAttributes = this._amazonAwsSQSConnector.getAmazonSQS().getQueueAttributes(request).getAttributes();
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to get queue ARN for queue " + this._queueUrl, e);
        }
        return (String)queueAttributes.get(ATTRIBUTE_QUEUE_ARN);
    }

    @Override
    public void setPolicy(String policy) throws JMSException {
        try {
            this._amazonAwsSQSConnector.getAmazonSQS().setQueueAttributes(new SetQueueAttributesRequest(this._queueUrl, Collections.singletonMap(ATTRIBUTE_POLICY, policy)));
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to set policy", e);
        }
    }

    @Override
    public void deleteMessage(String sqsReceiptHandle) throws JMSException {
        try {
            this._amazonAwsSQSConnector.getAmazonSQS().deleteMessage(new DeleteMessageRequest(this._queueUrl, sqsReceiptHandle));
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to delete message with receipt handle " + sqsReceiptHandle, e);
        }
    }

    @Override
    public AmazonAwsSQSMessage receiveMessage() throws JMSException {
        AmazonAwsSQSMessage sqsMessage;
        try {
            ReceiveMessageRequest request = new ReceiveMessageRequest(this._queueUrl).withAttributeNames(new String[]{"ApproximateReceiveCount"});
            ReceiveMessageResult result = this._amazonAwsSQSConnector.getAmazonSQS().receiveMessage(request);
            List messages = result.getMessages();
            sqsMessage = messages != null && messages.size() > 0 ? new AmazonAwsSQSMessage((Message)messages.get(0)) : null;
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to retrieve message from queue " + this._queueUrl, e);
        }
        return sqsMessage;
    }

    @Override
    public void deleteQueue() throws JMSException {
        try {
            this._amazonAwsSQSConnector.getAmazonSQS().deleteQueue(new DeleteQueueRequest(this._queueUrl));
        }
        catch (AmazonClientException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to delete message queue '" + this._queueUrl, e);
        }
    }
}

