/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.skyscreamer.nevado.jms.util.PropertyConvertUtil;
import org.skyscreamer.nevado.jms.util.SerializeUtil;

public abstract class AbstractMessage<T>
implements Message,
Serializable {
    public static final String WHITESPACE_CHARS = " \t\r\n";
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "IS", "ESCAPE"};
    private final Map<String, Object> _properties = new HashMap<String, Object>();
    String _messageID;
    private long _timestamp = 0L;
    private String _correlationID;
    private Destination _jmsReplyTo;
    private Destination _destination;
    private int _deliveryMode = 2;
    private boolean _redelivered = false;
    private String _type;
    private long _expiration = 0L;
    private int _priority = 0;
    private boolean _readOnlyProperties = false;
    private boolean _readOnlyBody = false;

    public String getJMSMessageID() throws JMSException {
        return this._messageID;
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        this._messageID = messageID;
    }

    public long getJMSTimestamp() throws JMSException {
        return this._timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._timestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        try {
            return this._correlationID != null ? this._correlationID.getBytes("UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException(e.getMessage());
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            this._correlationID = correlationID != null ? new String(correlationID, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException(e.getMessage());
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this._correlationID = correlationID;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this._correlationID;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this._jmsReplyTo;
    }

    public void setJMSReplyTo(Destination jmsReplyTo) throws JMSException {
        this._jmsReplyTo = jmsReplyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this._destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this._deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this._deliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this._redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this._type;
    }

    public void setJMSType(String type) throws JMSException {
        this._type = type;
    }

    public long getJMSExpiration() throws JMSException {
        return this._expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this._expiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        return this._priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new IllegalArgumentException("Priority must be a number between 0-9.  Given: " + priority);
        }
        this._priority = priority;
    }

    public void clearProperties() throws JMSException {
        this._properties.clear();
        this._readOnlyProperties = false;
    }

    public abstract void internalClearBody() throws JMSException;

    public void clearBody() throws JMSException {
        this.internalClearBody();
        this._readOnlyBody = false;
    }

    public boolean propertyExists(String propertyName) throws JMSException {
        return this._properties.containsKey(propertyName);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToBoolean("property " + name, this.getObjectProperty(name));
    }

    public byte getByteProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToByte("property " + name, this.getObjectProperty(name));
    }

    public short getShortProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToShort("property " + name, this.getObjectProperty(name));
    }

    public int getIntProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToInt("property " + name, this.getObjectProperty(name));
    }

    public long getLongProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToLong("property " + name, this.getObjectProperty(name));
    }

    public float getFloatProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToFloat("property " + name, this.getObjectProperty(name));
    }

    public double getDoubleProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToDouble("property " + name, this.getObjectProperty(name));
    }

    public String getStringProperty(String name) throws JMSException {
        return PropertyConvertUtil.convertToString("property " + name, this.getObjectProperty(name));
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        return this._properties.get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return new Vector<String>(this._properties.keySet()).elements();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, Float.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkReadOnlyProperties();
        this.checkValidPropertyName(name);
        this.internalSetObjectProperty(name, value);
    }

    public void setObjectPropertyIgnoreReadOnly(String name, Object value) throws JMSException {
        this.checkValidPropertyName(name);
        this.internalSetObjectProperty(name, value);
    }

    protected void internalSetObjectProperty(String name, Object value) throws JMSException {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("Property name cannot be empty or null");
        }
        PropertyConvertUtil.checkValidObject(value);
        this._properties.put(name, value);
    }

    public abstract void acknowledge() throws JMSException;

    private void checkReadOnlyProperties() throws MessageNotWriteableException {
        if (this._readOnlyProperties) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws MessageNotWriteableException {
        if (this._readOnlyBody) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
    }

    protected void checkWriteOnlyBody() throws MessageNotReadableException {
        if (!this._readOnlyBody) {
            throw new MessageNotReadableException("Message body is write-only");
        }
    }

    private void checkValidPropertyName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Property name cannot be empty");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new IllegalArgumentException("Invalid first character: " + name.charAt(0));
        }
        if (Arrays.asList(RESERVED_PROPERTY_NAMES).contains(name)) {
            throw new IllegalArgumentException("Property name cannot be reserved word '" + name + "'");
        }
        if (name.startsWith("JMS_nevado")) {
            throw new IllegalArgumentException("Property name cannot start with provider-reserved prefix of JMS_nevado");
        }
        for (char c : WHITESPACE_CHARS.toCharArray()) {
            if (name.indexOf(c) <= -1) continue;
            throw new IllegalArgumentException("Property name cannot contain whitespace: '" + name + "'");
        }
    }

    public void onSend() {
        this._readOnlyProperties = true;
        this._readOnlyBody = true;
    }

    public T copyOf() throws JMSException {
        try {
            byte[] data = SerializeUtil.serialize(this);
            return (T)SerializeUtil.deserialize(data);
        }
        catch (IOException e) {
            throw new JMSException("Unable to make copy of messsage: " + e.getMessage());
        }
    }
}

