/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.db;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.snmp4j.agent.db.MOXodusPersistence;
import org.snmp4j.agent.io.ImportMode;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.mo.MOPriorityProvider;
import org.snmp4j.cfg.EngineBootsProvider;
import org.snmp4j.cfg.EngineIdProvider;
import org.snmp4j.smi.OctetString;

public class MOXodusPersistenceProvider
implements MOPersistenceProvider,
EngineBootsProvider,
EngineIdProvider {
    private static final String ENGINE_STORE_ID = "_SNMP4J-Agent_EngineStore_______v3.0";
    private static final String BOOTS_COUNTER_KEY = "BootsCounter";
    private static final String ENGINE_ID_KEY = "EngineID";
    private final MOXodusPersistence defaultPersistence;

    public MOXodusPersistenceProvider(MOXodusPersistence defaultPersistence) {
        this.defaultPersistence = defaultPersistence;
    }

    public void restore(String uri, int importMode) throws IOException {
        this.restore(uri, importMode, null);
    }

    public void restore(String uri, int importMode, MOPriorityProvider priorityProvider) throws IOException {
        boolean specialURI;
        MOXodusPersistence persistence = this.defaultPersistence;
        boolean bl = specialURI = uri != null && !uri.equals(this.getDefaultURI());
        if (specialURI) {
            persistence = new MOXodusPersistence(this.defaultPersistence.getMOServer(), Environments.newInstance((String)this.getFilePath(uri)));
        }
        persistence.load(ImportMode.values()[importMode], priorityProvider);
        if (specialURI) {
            persistence.getEnvironment().close();
        }
    }

    public void store(String uri) throws IOException {
        this.store(uri, null);
    }

    public void store(String uri, MOPriorityProvider priorityProvider) throws IOException {
        boolean specialURI;
        MOXodusPersistence persistence = this.defaultPersistence;
        boolean bl = specialURI = uri != null && !uri.equals(this.getDefaultURI());
        if (specialURI) {
            persistence = new MOXodusPersistence(this.defaultPersistence.getMOServer(), Environments.newInstance((String)this.getFilePath(uri)));
        }
        persistence.save(priorityProvider);
        if (specialURI) {
            persistence.getEnvironment().close();
        }
    }

    public boolean isValidPersistenceURI(String uriString) {
        try {
            URI uri = new URI(uriString);
            return uri.getScheme() == null || uri.getScheme().equals("file");
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public String getPersistenceProviderID() {
        return "default";
    }

    public String getDefaultURI() {
        return this.defaultPersistence.getEnvironment().getLocation();
    }

    private String getFilePath(String uri) {
        File f;
        if (uri.toUpperCase().startsWith("FILE:")) {
            URI u = URI.create(uri);
            f = new File(u);
        } else {
            f = new File(uri);
        }
        return f.getPath();
    }

    public int updateEngineBoots() {
        Environment environment = this.defaultPersistence.getEnvironment();
        Transaction txn = environment.beginExclusiveTransaction();
        Store store = environment.openStore(ENGINE_STORE_ID, StoreConfig.WITHOUT_DUPLICATES, txn);
        ArrayByteIterable bootsCounterKey = StringBinding.stringToEntry((String)BOOTS_COUNTER_KEY);
        ByteIterable bootsCounterRaw = store.get(txn, (ByteIterable)bootsCounterKey);
        int bootsCounter = 0;
        if (bootsCounterRaw != null) {
            bootsCounter = IntegerBinding.entryToInt((ByteIterable)bootsCounterRaw);
            store.put(txn, (ByteIterable)bootsCounterKey, (ByteIterable)IntegerBinding.intToEntry((int)(++bootsCounter)));
        }
        txn.flush();
        txn.commit();
        return bootsCounter;
    }

    public int getEngineBoots() {
        Environment environment = this.defaultPersistence.getEnvironment();
        Transaction txn = environment.beginReadonlyTransaction();
        Store store = environment.openStore(ENGINE_STORE_ID, StoreConfig.WITHOUT_DUPLICATES, txn);
        ArrayByteIterable bootsCounterKey = StringBinding.stringToEntry((String)BOOTS_COUNTER_KEY);
        ByteIterable bootsCounterRaw = store.get(txn, (ByteIterable)bootsCounterKey);
        int bootsCounter = 0;
        if (bootsCounterRaw != null) {
            bootsCounter = IntegerBinding.entryToInt((ByteIterable)bootsCounterRaw);
        }
        txn.abort();
        return bootsCounter;
    }

    public OctetString getEngineId(OctetString defaultEngineID) {
        Environment environment = this.defaultPersistence.getEnvironment();
        Transaction txn = environment.beginExclusiveTransaction();
        Store store = environment.openStore(ENGINE_STORE_ID, StoreConfig.WITHOUT_DUPLICATES, txn);
        ArrayByteIterable engineIdKey = StringBinding.stringToEntry((String)ENGINE_ID_KEY);
        ByteIterable engineIdRaw = store.get(txn, (ByteIterable)engineIdKey);
        byte[] engineID = null;
        if (engineIdRaw != null) {
            engineID = new byte[engineIdRaw.getLength()];
            System.arraycopy(engineIdRaw.getBytesUnsafe(), 0, engineID, 0, engineID.length);
        } else if (defaultEngineID != null) {
            engineID = defaultEngineID.getValue();
            this.resetEngineId(txn, store, engineID);
        }
        txn.flush();
        txn.commit();
        return engineIdRaw != null ? new OctetString(engineID) : defaultEngineID;
    }

    public void resetEngineId(OctetString engineId) {
        Environment environment = this.defaultPersistence.getEnvironment();
        Transaction txn = environment.beginExclusiveTransaction();
        Store store = environment.openStore(ENGINE_STORE_ID, StoreConfig.WITHOUT_DUPLICATES, txn);
        this.resetEngineId(txn, store, engineId.getValue());
    }

    private void resetEngineId(Transaction txn, Store store, byte[] engineID) {
        ArrayByteIterable engineIdKey = StringBinding.stringToEntry((String)ENGINE_ID_KEY);
        store.put(txn, (ByteIterable)engineIdKey, (ByteIterable)new ArrayByteIterable(engineID));
        ArrayByteIterable bootsCounterKey = StringBinding.stringToEntry((String)BOOTS_COUNTER_KEY);
        store.put(txn, (ByteIterable)bootsCounterKey, (ByteIterable)IntegerBinding.intToEntry((int)1));
    }

    public void close() throws Exception {
        MOXodusPersistence persistence = this.defaultPersistence;
        if (persistence != null) {
            persistence.getEnvironment().close();
        }
    }
}

