/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3346")
public class AssertOnBooleanVariableCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern SIDE_EFFECT_METHOD_NAMES = Pattern.compile("^(remove|delete|retain|put|set|add|pop|update).*$", 2);

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ASSERT_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ((AssertStatementTree)tree).condition().accept((TreeVisitor)new MethodInvocationVisitor());
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            IdentifierTree methodNameTree = MethodsHelper.methodName(tree);
            if (SIDE_EFFECT_METHOD_NAMES.matcher(methodNameTree.name()).find()) {
                AssertOnBooleanVariableCheck.this.reportIssue((Tree)methodNameTree, "Move this \"assert\" side effect to another statement.");
            } else {
                super.visitMethodInvocation(tree);
            }
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

