/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2186")
public class AssertionInThreadRunCheck
extends IssuableSubscriptionVisitor {
    private static final Iterable<String> CHECKED_TYPES = ImmutableList.of((Object)"org.junit.Assert", (Object)"junit.framework.Assert", (Object)"junit.framework.TestCase", (Object)"org.fest.assertions.Assertions");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null && AssertionInThreadRunCheck.isRunMethod(methodTree)) {
            block.accept((TreeVisitor)new AssertionsVisitor());
        }
    }

    private static boolean isRunMethod(MethodTree methodTree) {
        return methodTree.symbol().owner().type().isSubtypeOf("java.lang.Runnable") && "run".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty();
    }

    private class AssertionsVisitor
    extends BaseTreeVisitor {
        private AssertionsVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Type type;
            if (tree.symbol().isMethodSymbol() && this.isCheckedType(type = tree.symbol().owner().type())) {
                AssertionInThreadRunCheck.this.reportIssue((Tree)MethodsHelper.methodName(tree), "Remove this assertion.");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isCheckedType(Type type) {
            for (String checkedType : CHECKED_TYPES) {
                if (!type.is(checkedType)) continue;
                return true;
            }
            return false;
        }
    }
}

