/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2184")
public class CastArithmeticOperandCheck
extends IssuableSubscriptionVisitor {
    private static final Map<Tree.Kind, String> OPERATION_BY_KIND = ImmutableMap.builder().put((Object)Tree.Kind.PLUS, (Object)"addition").put((Object)Tree.Kind.MINUS, (Object)"subtraction").put((Object)Tree.Kind.MULTIPLY, (Object)"multiplication").put((Object)Tree.Kind.DIVIDE, (Object)"division").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.DIVIDE);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            switch (tree.kind()) {
                case ASSIGNMENT: {
                    AssignmentExpressionTree aet = (AssignmentExpressionTree)tree;
                    Type varType = aet.symbolType();
                    ExpressionTree expr = aet.expression();
                    this.checkExpression(varType, expr);
                    break;
                }
                case VARIABLE: {
                    VariableTree variableTree = (VariableTree)tree;
                    Type varType = variableTree.type().symbolType();
                    ExpressionTree expr = variableTree.initializer();
                    this.checkExpression(varType, expr);
                    break;
                }
                case METHOD_INVOCATION: {
                    this.checkMethodInvocationArgument((MethodInvocationTree)tree);
                    break;
                }
                case METHOD: {
                    this.checkMethodTree((MethodTreeImpl)tree);
                    break;
                }
                case DIVIDE: {
                    BinaryExpressionTree binaryExpr = (BinaryExpressionTree)tree;
                    if (!CastArithmeticOperandCheck.isIntOrLong(binaryExpr.symbolType())) break;
                    this.checkIntegerDivisionInsideFloatingPointExpression(binaryExpr);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Tree " + tree.kind() + " not handled.");
                }
            }
        }
    }

    private void checkMethodTree(MethodTreeImpl methodTree) {
        Type returnType;
        TypeTree returnTypeTree = methodTree.returnType();
        Type type = returnType = returnTypeTree != null ? returnTypeTree.symbolType() : null;
        if (returnType != null && CastArithmeticOperandCheck.isVarTypeErrorProne(returnType)) {
            methodTree.accept((TreeVisitor)new ReturnStatementVisitor(returnType));
        }
    }

    private void checkMethodInvocationArgument(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        if (symbol.isMethodSymbol()) {
            List parametersTypes = ((Symbol.MethodSymbol)symbol).parameterTypes();
            if (mit.arguments().size() == parametersTypes.size()) {
                int i = 0;
                for (Type argType : parametersTypes) {
                    this.checkExpression(argType, (ExpressionTree)mit.arguments().get(i));
                    ++i;
                }
            }
        }
    }

    private void checkExpression(Type varType, @Nullable ExpressionTree expr) {
        if (CastArithmeticOperandCheck.isVarTypeErrorProne(varType) && expr != null && CastArithmeticOperandCheck.expressionIsOperationToIntOrLong(expr)) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)expr;
            if (binaryExpressionTree.is(new Tree.Kind[]{Tree.Kind.DIVIDE}) && varType.isPrimitive(Type.Primitives.LONG)) {
                return;
            }
            if (varType.isPrimitive(Type.Primitives.LONG) && expr.symbolType().isPrimitive(Type.Primitives.LONG)) {
                return;
            }
            this.reportIssue((Tree)binaryExpressionTree.operatorToken(), "Cast one of the operands of this " + OPERATION_BY_KIND.get(expr.kind()) + " operation to a \"" + varType.name() + "\".");
        }
    }

    private static boolean expressionIsOperationToIntOrLong(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.PLUS, Tree.Kind.MINUS}) && CastArithmeticOperandCheck.isIntOrLong(expr.symbolType());
    }

    private static boolean isIntOrLong(Type exprType) {
        return exprType.isPrimitive(Type.Primitives.INT) || exprType.isPrimitive(Type.Primitives.LONG);
    }

    private static boolean isVarTypeErrorProne(Type varType) {
        return varType.isPrimitive(Type.Primitives.LONG) || varType.isPrimitive(Type.Primitives.FLOAT) || varType.isPrimitive(Type.Primitives.DOUBLE);
    }

    private void checkIntegerDivisionInsideFloatingPointExpression(BinaryExpressionTree integerDivision) {
        Tree parent = integerDivision.parent();
        while (parent instanceof ExpressionTree) {
            ExpressionTree expressionTree = (ExpressionTree)parent;
            if (CastArithmeticOperandCheck.isFloatingPoint(expressionTree.symbolType())) {
                this.reportIssue((Tree)integerDivision, "Cast one of the operands of this integer division to a \"double\".");
                break;
            }
            parent = expressionTree.parent();
        }
    }

    private static boolean isFloatingPoint(Type exprType) {
        return exprType.isPrimitive(Type.Primitives.DOUBLE) || exprType.isPrimitive(Type.Primitives.FLOAT);
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private Type returnType;

        public ReturnStatementVisitor(Type returnType) {
            this.returnType = returnType;
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            CastArithmeticOperandCheck.this.checkExpression(this.returnType, tree.expression());
        }
    }
}

