/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.cfg.VariableReadExtractor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1854")
public class DeadStoreCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() == null) {
            return;
        }
        if (DeadStoreCheck.hasTryFinallyWithLocalVar(methodTree.block(), methodTree.symbol())) {
            return;
        }
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        CFG cfg = CFG.build((MethodTree)methodTree);
        LiveVariables liveVariables = LiveVariables.analyze((CFG)cfg);
        for (CFG.Block block : cfg.blocks()) {
            this.checkElements(block, liveVariables.getOut(block), methodSymbol);
        }
    }

    private void checkElements(CFG.Block block, Set<Symbol> blockOut, Symbol.MethodSymbol methodSymbol) {
        HashSet<Symbol> out = new HashSet<Symbol>(blockOut);
        HashSet assignmentLHS = new HashSet();
        Lists.reverse((List)block.elements()).forEach(element -> this.checkElement(methodSymbol, (Set<Symbol>)out, assignmentLHS, (Tree)element));
    }

    private Set<Symbol> checkElement(Symbol.MethodSymbol methodSymbol, Set<Symbol> outVar, Set<Tree> assignmentLHS, Tree element) {
        Set<Symbol> out = outVar;
        switch (element.kind()) {
            case PLUS_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case ASSIGNMENT: {
                this.handleAssignment(out, assignmentLHS, (AssignmentExpressionTree)element);
                break;
            }
            case IDENTIFIER: {
                DeadStoreCheck.handleIdentifier(out, assignmentLHS, (IdentifierTree)element);
                break;
            }
            case VARIABLE: {
                this.handleVariable(out, (VariableTree)element);
                break;
            }
            case NEW_CLASS: {
                DeadStoreCheck.handleNewClass(out, methodSymbol, (NewClassTree)element);
                break;
            }
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree lambda = (LambdaExpressionTree)element;
                out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(lambda.body(), methodSymbol));
                break;
            }
            case METHOD_REFERENCE: {
                MethodReferenceTree methodRef = (MethodReferenceTree)element;
                out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(methodRef.expression(), methodSymbol));
                break;
            }
            case TRY_STATEMENT: {
                DeadStoreCheck.handleTryStatement(out, methodSymbol, (TryStatementTree)element);
                break;
            }
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                this.handlePrefixExpression(out, (UnaryExpressionTree)element);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                this.handlePostfixExpression(out, (UnaryExpressionTree)element);
                break;
            }
            case CLASS: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                ClassTree classTree = (ClassTree)element;
                out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree((Tree)classTree, methodSymbol));
                break;
            }
        }
        return out;
    }

    private void handleAssignment(Set<Symbol> out, Set<Tree> assignmentLHS, AssignmentExpressionTree element) {
        ExpressionTree lhs = ExpressionUtils.skipParentheses((ExpressionTree)element.variable());
        if (lhs.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)lhs).symbol();
            if (DeadStoreCheck.isLocalVariable(symbol) && !out.contains(symbol) && (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || DeadStoreCheck.isParentExpressionStatement((Tree)element))) {
                this.createIssue((Tree)element.operatorToken(), (Tree)element.expression(), symbol);
            }
            assignmentLHS.add((Tree)lhs);
            if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                out.remove(symbol);
            } else {
                out.add(symbol);
            }
        }
    }

    private static boolean isParentExpressionStatement(Tree element) {
        return element.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    private static void handleIdentifier(Set<Symbol> out, Set<Tree> assignmentLHS, IdentifierTree element) {
        Symbol symbol = element.symbol();
        if (!assignmentLHS.contains(element) && DeadStoreCheck.isLocalVariable(symbol)) {
            out.add(symbol);
        }
    }

    private void handleVariable(Set<Symbol> out, VariableTree localVar) {
        Symbol symbol = localVar.symbol();
        ExpressionTree initializer = localVar.initializer();
        if (initializer != null && !DeadStoreCheck.isUsualDefaultValue(initializer) && !out.contains(symbol)) {
            this.createIssue((Tree)((VariableTreeImpl)localVar).equalToken(), (Tree)initializer, symbol);
        }
        out.remove(symbol);
    }

    private static boolean isUsualDefaultValue(ExpressionTree tree) {
        ExpressionTree expr = ExpressionUtils.skipParentheses((ExpressionTree)tree);
        switch (expr.kind()) {
            case BOOLEAN_LITERAL: 
            case NULL_LITERAL: {
                return true;
            }
            case STRING_LITERAL: {
                return DeadStoreCheck.isEmptyString((LiteralTree)expr);
            }
            case INT_LITERAL: {
                String value = ((LiteralTree)expr).value();
                return "0".equals(value) || "1".equals(value);
            }
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                return DeadStoreCheck.isUsualDefaultValue(((UnaryExpressionTree)expr).expression());
            }
        }
        return false;
    }

    private static boolean isEmptyString(LiteralTree expr) {
        return LiteralUtils.trimQuotes((String)expr.value()).isEmpty();
    }

    private static void handleNewClass(Set<Symbol> out, Symbol.MethodSymbol methodSymbol, NewClassTree element) {
        ClassTree body = element.classBody();
        if (body != null) {
            out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree((Tree)body, methodSymbol));
        }
    }

    private static void handleTryStatement(Set<Symbol> out, Symbol.MethodSymbol methodSymbol, TryStatementTree element) {
        AssignedLocalVarVisitor visitor = new AssignedLocalVarVisitor();
        element.block().accept((TreeVisitor)visitor);
        out.addAll(visitor.assignedLocalVars);
        for (CatchTree catchTree : element.catches()) {
            out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree((Tree)catchTree, methodSymbol));
        }
    }

    private void handlePrefixExpression(Set<Symbol> out, UnaryExpressionTree element) {
        Symbol symbol;
        ExpressionTree expression = element.expression();
        if (DeadStoreCheck.isParentExpressionStatement((Tree)element) && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && DeadStoreCheck.isLocalVariable(symbol = ((IdentifierTree)expression).symbol()) && !out.contains(symbol)) {
            this.createIssue((Tree)element, symbol);
        }
    }

    private void handlePostfixExpression(Set<Symbol> out, UnaryExpressionTree element) {
        Symbol symbol;
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)element.expression());
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && DeadStoreCheck.isLocalVariable(symbol = ((IdentifierTree)expression).symbol()) && !out.contains(symbol)) {
            this.createIssue((Tree)element, symbol);
        }
    }

    private void createIssue(Tree element, Symbol symbol) {
        this.reportIssue(element, DeadStoreCheck.getMessage(symbol));
    }

    private void createIssue(Tree startTree, Tree endTree, Symbol symbol) {
        this.reportIssue(startTree, endTree, DeadStoreCheck.getMessage(symbol));
    }

    private static String getMessage(Symbol symbol) {
        return "Remove this useless assignment to local variable \"" + symbol.name() + "\".";
    }

    private static Set<Symbol> getUsedLocalVarInSubTree(Tree tree, Symbol.MethodSymbol methodSymbol) {
        VariableReadExtractor localVarExtractor = new VariableReadExtractor(methodSymbol, false);
        tree.accept((TreeVisitor)localVarExtractor);
        return localVarExtractor.usedVariables();
    }

    private static boolean hasTryFinallyWithLocalVar(BlockTree block, Symbol.MethodSymbol methodSymbol) {
        TryVisitor tryVisitor = new TryVisitor(methodSymbol);
        block.accept((TreeVisitor)tryVisitor);
        return tryVisitor.hasTryFinally;
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.owner().isMethodSymbol();
    }

    private static class AssignedLocalVarVisitor
    extends BaseTreeVisitor {
        List<Symbol> assignedLocalVars = new ArrayList<Symbol>();

        private AssignedLocalVarVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ExpressionTree lhs = ExpressionUtils.skipParentheses((ExpressionTree)tree.variable());
            if (lhs.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol symbol = ((IdentifierTree)lhs).symbol();
                if (DeadStoreCheck.isLocalVariable(symbol)) {
                    this.assignedLocalVars.add(symbol);
                }
                super.visitAssignmentExpression(tree);
            }
        }
    }

    private static class TryVisitor
    extends BaseTreeVisitor {
        boolean hasTryFinally = false;
        Symbol.MethodSymbol methodSymbol;

        TryVisitor(Symbol.MethodSymbol methodSymbol) {
            this.methodSymbol = methodSymbol;
        }

        public void visitTryStatement(TryStatementTree tree) {
            BlockTree finallyBlock = tree.finallyBlock();
            this.hasTryFinally |= finallyBlock != null && !DeadStoreCheck.getUsedLocalVarInSubTree((Tree)finallyBlock, this.methodSymbol).isEmpty() || !tree.resources().isEmpty();
            if (!this.hasTryFinally) {
                super.visitTryStatement(tree);
            }
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

