/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1994")
public class ForLoopIncrementAndUpdateCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        Map<Symbol, Tree> updatesInBody;
        if (!this.hasSemantic()) {
            return;
        }
        ForStatementTree forStatementTree = (ForStatementTree)tree;
        if (forStatementTree.update().isEmpty() || forStatementTree.condition() == null) {
            return;
        }
        Collection<Symbol> symbolsFromConditionsNotUpdated = ForLoopIncrementAndUpdateCheck.symbolsFromConditionsNotUpdated(forStatementTree);
        if (!symbolsFromConditionsNotUpdated.isEmpty() && !(updatesInBody = ForLoopIncrementAndUpdateCheck.singleUpdatesInBody(forStatementTree.statement(), symbolsFromConditionsNotUpdated)).isEmpty()) {
            this.reportIssue((Tree)forStatementTree.forKeyword(), ForLoopIncrementAndUpdateCheck.getMessage(updatesInBody.keySet()), ForLoopIncrementAndUpdateCheck.getSecondaries(updatesInBody.values()), null);
        }
    }

    private static String getMessage(Set<Symbol> updates) {
        return String.format("Move the update of %s into this loop's update clause.", ForLoopIncrementAndUpdateCheck.symbolNames(updates));
    }

    private static Collection<Symbol> symbolsFromConditionsNotUpdated(ForStatementTree forStatementTree) {
        Collection<Symbol> symbols = ForLoopIncrementAndUpdateCheck.getConditionSymbols(forStatementTree.condition());
        symbols.removeAll(ForLoopIncrementAndUpdateCheck.getUpdatedSymbols((ListTree<StatementTree>)forStatementTree.update()));
        return symbols;
    }

    private static Collection<Symbol> getConditionSymbols(ExpressionTree condition) {
        ConditionVisitor conditionVisitor = new ConditionVisitor();
        condition.accept((TreeVisitor)conditionVisitor);
        return conditionVisitor.symbols;
    }

    private static Collection<Symbol> getUpdatedSymbols(ListTree<StatementTree> updates) {
        UpdateVisitor updateVisitor = new UpdateVisitor();
        updates.accept((TreeVisitor)updateVisitor);
        return updateVisitor.symbols;
    }

    private static Map<Symbol, Tree> singleUpdatesInBody(StatementTree statement, Collection<Symbol> conditionsNotUpdated) {
        UpdatesInBodyVisitor updatedInBodyVisitor = new UpdatesInBodyVisitor(conditionsNotUpdated);
        statement.accept((TreeVisitor)updatedInBodyVisitor);
        return ForLoopIncrementAndUpdateCheck.updatedOnlyOnceWithUnaryExpression((Multimap<Symbol, Tree>)updatedInBodyVisitor.updates, statement);
    }

    private static String symbolNames(Set<Symbol> symbols) {
        return symbols.stream().map(s -> "\"" + s.name() + "\"").sorted().collect(Collectors.joining(","));
    }

    private static List<JavaFileScannerContext.Location> getSecondaries(Collection<Tree> updateTrees) {
        return updateTrees.stream().map(t -> new JavaFileScannerContext.Location("", t)).collect(Collectors.toList());
    }

    private static Map<Symbol, Tree> updatedOnlyOnceWithUnaryExpression(Multimap<Symbol, Tree> updatesInBody, StatementTree forStatementBody) {
        HashMap<Symbol, Tree> result = new HashMap<Symbol, Tree>();
        for (Symbol updatedSymbol : updatesInBody.keySet()) {
            Tree updateTree;
            Collection updateTrees = updatesInBody.get((Object)updatedSymbol);
            if (updateTrees.size() != 1 || !(updateTree = (Tree)updateTrees.iterator().next()).is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT}) || !updateTree.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || updateTree.parent().parent() != forStatementBody) continue;
            result.put(updatedSymbol, updateTree);
        }
        return result;
    }

    private static class UpdatesInBodyVisitor
    extends BaseTreeVisitor {
        private final Collection<Symbol> targets;
        private final Multimap<Symbol, Tree> updates = ArrayListMultimap.create();

        private UpdatesInBodyVisitor(Collection<Symbol> targets) {
            this.targets = targets;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkIdentifier(tree.variable(), (Tree)tree);
            super.visitAssignmentExpression(tree);
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkIdentifier(tree.expression(), (Tree)tree);
            super.visitUnaryExpression(tree);
        }

        private void checkIdentifier(ExpressionTree expression, Tree root) {
            ExpressionTree expr = ExpressionUtils.skipParentheses((ExpressionTree)expression);
            if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.addSymbol((IdentifierTree)expr, root);
            } else if (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.addSymbol(((MemberSelectExpressionTree)expr).identifier(), root);
            }
        }

        private void addSymbol(IdentifierTree identifierTree, Tree root) {
            Symbol symbol = identifierTree.symbol();
            if (this.targets.contains(symbol)) {
                this.updates.put((Object)symbol, (Object)root);
            }
        }
    }

    private static class UpdateVisitor
    extends BaseTreeVisitor {
        Collection<Symbol> symbols = new ArrayList<Symbol>();

        private UpdateVisitor() {
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkIdentifier(tree.expression());
            super.visitUnaryExpression(tree);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkIdentifier(tree.variable());
            super.visitAssignmentExpression(tree);
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            this.checkIdentifier((ExpressionTree)tree.identifier());
        }

        private void checkIdentifier(ExpressionTree expression) {
            ExpressionTree expr = ExpressionUtils.skipParentheses((ExpressionTree)expression);
            if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.addSymbol((IdentifierTree)expr);
            } else if (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.addSymbol(((MemberSelectExpressionTree)expr).identifier());
            }
        }

        private void addSymbol(IdentifierTree identifierTree) {
            Symbol symbol = identifierTree.symbol();
            if (!symbol.isUnknown()) {
                this.symbols.add(symbol);
            }
        }
    }

    private static class ConditionVisitor
    extends BaseTreeVisitor {
        Collection<Symbol> symbols = new HashSet<Symbol>();

        private ConditionVisitor() {
        }

        public void visitIdentifier(IdentifierTree tree) {
            Symbol symbol = tree.symbol();
            if (symbol.isVariableSymbol()) {
                this.symbols.add(symbol);
            }
            super.visitIdentifier(tree);
        }
    }
}

