/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1145")
public class IfConditionAlwaysTrueOrFalseCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree condition = ((IfStatementTree)tree).condition();
        if (condition.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            this.reportIssue((Tree)condition, "Remove this if statement.");
        }
    }
}

