/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2226")
public class ServletInstanceFieldCheck
extends IssuableSubscriptionVisitor {
    private List<VariableTree> issuableVariables = new ArrayList<VariableTree>();
    private List<VariableTree> excludedVariables = new ArrayList<VariableTree>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD);
    }

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        super.scanFile(context);
        this.reportIssuesOnVariable();
    }

    public void visitNode(Tree tree) {
        VariableTree variable;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && ServletInstanceFieldCheck.isServletInit((MethodTree)tree)) {
            tree.accept((TreeVisitor)new AssignmentVisitor());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ServletInstanceFieldCheck.isOwnedByAServlet(variable = (VariableTree)tree) && !ServletInstanceFieldCheck.isExcluded(variable)) {
            this.issuableVariables.add(variable);
        }
    }

    private static boolean isExcluded(VariableTree variable) {
        return ServletInstanceFieldCheck.isStaticOrFinal(variable) || variable.symbol().metadata().isAnnotatedWith("javax.inject.Inject");
    }

    private static boolean isServletInit(MethodTree tree) {
        return "init".equals(tree.simpleName().name()) && tree.parameters().size() == 1 && ((VariableTree)tree.parameters().get(0)).symbol().type().is("javax.servlet.ServletConfig");
    }

    private void reportIssuesOnVariable() {
        this.issuableVariables.removeAll(this.excludedVariables);
        for (VariableTree variable : this.issuableVariables) {
            this.reportIssue((Tree)variable.simpleName(), "Remove this misleading mutable servlet instance field or make it \"static\" and/or \"final\"");
        }
        this.issuableVariables.clear();
        this.excludedVariables.clear();
    }

    private static boolean isOwnedByAServlet(VariableTree variable) {
        Symbol owner = variable.symbol().owner();
        return owner.isTypeSymbol() && (owner.type().isSubtypeOf("javax.servlet.http.HttpServlet") || owner.type().isSubtypeOf("org.apache.struts.action.Action"));
    }

    private static boolean isStaticOrFinal(VariableTree variable) {
        ModifiersTree modifiers = variable.modifiers();
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC) || ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.FINAL);
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private AssignmentVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            Tree declaration;
            if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (declaration = ((IdentifierTree)tree.variable()).symbol().declaration()) != null && declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                ServletInstanceFieldCheck.this.excludedVariables.add((VariableTree)declaration);
            }
        }
    }
}

