/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1844")
public class WaitOnConditionCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        TypeCriteria conditionSubType = TypeCriteria.subtypeOf((String)"java.util.concurrent.locks.Condition");
        return ImmutableList.builder().add((Object)MethodMatcher.create().callSite(conditionSubType).name("wait").withoutParameter()).add((Object)MethodMatcher.create().callSite(conditionSubType).name("wait").addParameter("long")).add((Object)MethodMatcher.create().callSite(conditionSubType).name("wait").addParameter("long").addParameter("int")).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }
}

